"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPanelFlyout = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _errors = require("../../../../errors");
var _saved_object_finder_create_new = require("./saved_object_finder_create_new");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function capitalize([first, ...letters]) {
  return `${first.toUpperCase()}${letters.join('')}`;
}
class AddPanelFlyout extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "lastToast", void 0);
    (0, _defineProperty2.default)(this, "state", {
      isCreateMenuOpen: false
    });
    (0, _defineProperty2.default)(this, "showToast", name => {
      // To avoid the clutter of having toast messages cover flyout
      // close previous toast message before creating a new one
      if (this.lastToast) {
        this.props.notifications.toasts.remove(this.lastToast);
      }
      this.lastToast = this.props.notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('embeddableApi.addPanel.savedObjectAddedToContainerSuccessMessageTitle', {
          defaultMessage: '{savedObjectName} was added',
          values: {
            savedObjectName: name
          }
        }),
        'data-test-subj': 'addObjectToContainerSuccess'
      });
    });
    (0, _defineProperty2.default)(this, "createNewEmbeddable", async type => {
      this.props.onClose();
      const factory = this.props.getFactory(type);
      if (!factory) {
        throw new _errors.EmbeddableFactoryNotFoundError(type);
      }
      const explicitInput = await factory.getExplicitInput();
      const embeddable = await this.props.container.addNewEmbeddable(type, explicitInput);
      if (embeddable) {
        this.showToast(embeddable.getInput().title || '');
      }
    });
    (0, _defineProperty2.default)(this, "onAddPanel", async (savedObjectId, savedObjectType, name, so) => {
      const factoryForSavedObjectType = [...this.props.getAllFactories()].find(factory => factory.savedObjectMetaData && factory.savedObjectMetaData.type === savedObjectType);
      if (!factoryForSavedObjectType) {
        throw new _errors.EmbeddableFactoryNotFoundError(savedObjectType);
      }
      const embeddable = await this.props.container.addNewEmbeddable(factoryForSavedObjectType.type, {
        savedObjectId
      });
      this.doTelemetryForAddEvent(this.props.container.type, factoryForSavedObjectType, so);
      this.showToast(name);
      if (this.props.onAddPanel) {
        this.props.onAddPanel(embeddable.id);
      }
    });
  }
  doTelemetryForAddEvent(appName, factoryForSavedObjectType, so) {
    const {
      reportUiCounter
    } = this.props;
    if (reportUiCounter) {
      var _factoryForSavedObjec;
      const type = (_factoryForSavedObjec = factoryForSavedObjectType.savedObjectMetaData) !== null && _factoryForSavedObjec !== void 0 && _factoryForSavedObjec.getSavedObjectSubType ? factoryForSavedObjectType.savedObjectMetaData.getSavedObjectSubType(so) : factoryForSavedObjectType.type;
      reportUiCounter(appName, _analytics.METRIC_TYPE.CLICK, `${type}:add`);
    }
  }
  getCreateMenuItems() {
    return [...this.props.getAllFactories()].filter(
    // @ts-expect-error ts 4.5 upgrade
    factory => factory.isEditable() && !factory.isContainerType && factory.canCreateNew()).map(factory => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: factory.type,
      "data-test-subj": `createNew-${factory.type}`,
      onClick: () => this.createNewEmbeddable(factory.type),
      className: "embPanel__addItem"
    }, capitalize(factory.getDisplayName())));
  }
  render() {
    const SavedObjectFinder = this.props.SavedObjectFinder;
    const metaData = [...this.props.getAllFactories()].filter(embeddableFactory => Boolean(embeddableFactory.savedObjectMetaData) && !embeddableFactory.isContainerType).map(({
      savedObjectMetaData
    }) => savedObjectMetaData);
    const savedObjectsFinder = /*#__PURE__*/_react.default.createElement(SavedObjectFinder, {
      onChoose: this.onAddPanel,
      savedObjectMetaData: metaData,
      showFilter: true,
      noItemsMessage: _i18n.i18n.translate('embeddableApi.addPanel.noMatchingObjectsMessage', {
        defaultMessage: 'No matching objects found.'
      })
    }, this.props.showCreateNewMenu ? /*#__PURE__*/_react.default.createElement(_saved_object_finder_create_new.SavedObjectFinderCreateNew, {
      menuItems: this.getCreateMenuItems()
    }) : null);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "embeddableApi.addPanel.Title",
      defaultMessage: "Add from library"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, savedObjectsFinder));
  }
}
exports.AddPanelFlyout = AddPanelFlyout;