"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddablePanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _std = require("@kbn/std");
var _ui_actions = require("../ui_actions");
var _triggers = require("../triggers");
var _embeddables = require("../embeddables");
var _types = require("../types");
var _embeddable_panel_error = require("./embeddable_panel_error");
var _panel_actions = require("./panel_header/panel_actions");
var _add_panel_action = require("./panel_header/panel_actions/add_panel/add_panel_action");
var _customize_panel_action = require("./panel_header/panel_actions/customize_panel/customize_panel_action");
var _panel_header = require("./panel_header/panel_header");
var _inspect_panel_action = require("./panel_header/panel_actions/inspect_panel_action");
var _actions = require("../actions");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const sortByOrderField = ({
  order: orderA
}, {
  order: orderB
}) => (orderB || 0) - (orderA || 0);
const removeById = disabledActions => ({
  id
}) => disabledActions.indexOf(id) === -1;

/**
 * Embeddable container may provide information about its environment,
 * Use it for drilling down data that is static or doesn't have to be reactive,
 * otherwise prefer passing data with input$
 * */

class EmbeddablePanel extends _react.default.Component {
  constructor(props) {
    var _embeddable$getInput$, _embeddable$parent, _embeddable$parent$ge, _embeddable$getInput;
    super(props);
    (0, _defineProperty2.default)(this, "embeddableRoot", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)(this, "parentSubscription", void 0);
    (0, _defineProperty2.default)(this, "subscription", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "mounted", false);
    (0, _defineProperty2.default)(this, "generateId", (0, _eui.htmlIdGenerator)());
    (0, _defineProperty2.default)(this, "onFocus", focusedPanelIndex => {
      this.setState({
        focusedPanelIndex
      });
    });
    (0, _defineProperty2.default)(this, "onBlur", blurredPanelIndex => {
      if (this.state.focusedPanelIndex === blurredPanelIndex) {
        this.setState({
          focusedPanelIndex: undefined
        });
      }
    });
    (0, _defineProperty2.default)(this, "closeMyContextMenuPanel", () => {
      if (this.mounted) {
        this.setState({
          closeContextMenu: true
        }, () => {
          if (this.mounted) {
            this.setState({
              closeContextMenu: false
            });
          }
        });
      }
    });
    (0, _defineProperty2.default)(this, "getUniversalActions", () => {
      var _this$props$container;
      let actions = {};
      if (this.props.inspector) {
        actions = {
          inspectPanel: new _inspect_panel_action.InspectPanelAction(this.props.inspector)
        };
      }
      if (!this.props.getEmbeddableFactory || !this.props.getAllEmbeddableFactories || !this.props.overlays || !this.props.notifications || !this.props.SavedObjectFinder || !this.props.application) {
        return actions;
      }

      // Universal actions are exposed on the context menu for every embeddable, they bypass the trigger
      // registry.
      return {
        ...actions,
        customizePanel: new _customize_panel_action.CustomizePanelAction(this.props.overlays, this.props.theme, this.props.commonlyUsedRanges, this.props.dateFormat),
        addPanel: new _add_panel_action.AddPanelAction(this.props.getEmbeddableFactory, this.props.getAllEmbeddableFactories, this.props.overlays, this.props.notifications, this.props.SavedObjectFinder, this.props.theme, this.props.reportUiCounter),
        removePanel: new _panel_actions.RemovePanelAction(),
        editPanel: new _actions.EditPanelAction(this.props.getEmbeddableFactory, this.props.application, this.props.stateTransfer, (_this$props$container = this.props.containerContext) === null || _this$props$container === void 0 ? void 0 : _this$props$container.getCurrentPath)
      };
    });
    (0, _defineProperty2.default)(this, "getActionContextMenuPanel", async () => {
      var _await$this$props$get, _this$props$getAction, _this$props;
      let regularActions = (_await$this$props$get = await ((_this$props$getAction = (_this$props = this.props).getActions) === null || _this$props$getAction === void 0 ? void 0 : _this$props$getAction.call(_this$props, _triggers.CONTEXT_MENU_TRIGGER, {
        embeddable: this.props.embeddable
      }))) !== null && _await$this$props$get !== void 0 ? _await$this$props$get : [];
      const {
        disabledActions
      } = this.props.embeddable.getInput();
      if (disabledActions) {
        const removeDisabledActions = removeById(disabledActions);
        regularActions = regularActions.filter(removeDisabledActions);
      }
      let sortedActions = regularActions.concat(Object.values(this.state.universalActions || {})).sort(sortByOrderField);
      if (this.props.actionPredicate) {
        sortedActions = sortedActions.filter(({
          id
        }) => this.props.actionPredicate(id));
      }
      const panels = await (0, _ui_actions.buildContextMenuForActions)({
        actions: sortedActions.map(action => ({
          action,
          context: {
            embeddable: this.props.embeddable
          },
          trigger: _triggers.contextMenuTrigger
        })),
        closeMenu: this.closeMyContextMenuPanel
      });
      return {
        panels,
        actions: sortedActions
      };
    });
    const {
      embeddable
    } = this.props;
    const viewMode = (_embeddable$getInput$ = embeddable.getInput().viewMode) !== null && _embeddable$getInput$ !== void 0 ? _embeddable$getInput$ : _types.ViewMode.EDIT;
    const hidePanelTitle = Boolean((_embeddable$parent = embeddable.parent) === null || _embeddable$parent === void 0 ? void 0 : (_embeddable$parent$ge = _embeddable$parent.getInput()) === null || _embeddable$parent$ge === void 0 ? void 0 : _embeddable$parent$ge.hidePanelTitles) || Boolean((_embeddable$getInput = embeddable.getInput()) === null || _embeddable$getInput === void 0 ? void 0 : _embeddable$getInput.hidePanelTitles);
    this.state = {
      universalActions: this.getUniversalActions(),
      panels: [],
      viewMode,
      hidePanelTitle,
      closeContextMenu: false,
      badges: [],
      notifications: []
    };
  }
  async refreshBadges() {
    var _ref, _this$props$getAction2, _this$props2;
    if (!this.mounted) {
      return;
    }
    if (this.props.showBadges === false) {
      return;
    }
    let badges = (_ref = await ((_this$props$getAction2 = (_this$props2 = this.props).getActions) === null || _this$props$getAction2 === void 0 ? void 0 : _this$props$getAction2.call(_this$props2, _triggers.PANEL_BADGE_TRIGGER, {
      embeddable: this.props.embeddable
    }))) !== null && _ref !== void 0 ? _ref : [];
    const {
      disabledActions
    } = this.props.embeddable.getInput();
    if (disabledActions) {
      badges = badges.filter(badge => disabledActions.indexOf(badge.id) === -1);
    }
    if (!(0, _fastDeepEqual.default)(this.state.badges, badges)) {
      this.setState({
        badges
      });
    }
  }
  async refreshNotifications() {
    var _ref2, _this$props$getAction3, _this$props3;
    if (!this.mounted) {
      return;
    }
    if (this.props.showNotifications === false) {
      return;
    }
    let notifications = (_ref2 = await ((_this$props$getAction3 = (_this$props3 = this.props).getActions) === null || _this$props$getAction3 === void 0 ? void 0 : _this$props$getAction3.call(_this$props3, _triggers.PANEL_NOTIFICATION_TRIGGER, {
      embeddable: this.props.embeddable
    }))) !== null && _ref2 !== void 0 ? _ref2 : [];
    const {
      disabledActions
    } = this.props.embeddable.getInput();
    if (disabledActions) {
      notifications = notifications.filter(badge => disabledActions.indexOf(badge.id) === -1);
    }
    if (!(0, _fastDeepEqual.default)(this.state.notifications, notifications)) {
      this.setState({
        notifications
      });
    }
  }
  UNSAFE_componentWillMount() {
    this.mounted = true;
    const {
      embeddable
    } = this.props;
    const {
      parent
    } = embeddable;
    this.subscription.add(embeddable.getInput$().subscribe(async () => {
      if (this.mounted) {
        var _embeddable$getInput$2;
        this.setState({
          viewMode: (_embeddable$getInput$2 = embeddable.getInput().viewMode) !== null && _embeddable$getInput$2 !== void 0 ? _embeddable$getInput$2 : _types.ViewMode.EDIT
        });
        this.refreshBadges();
        this.refreshNotifications();
      }
    }));
    if (parent) {
      this.parentSubscription = parent.getInput$().subscribe(async () => {
        if (this.mounted && parent) {
          var _embeddable$parent2, _embeddable$parent2$g, _embeddable$getInput2;
          this.setState({
            hidePanelTitle: Boolean((_embeddable$parent2 = embeddable.parent) === null || _embeddable$parent2 === void 0 ? void 0 : (_embeddable$parent2$g = _embeddable$parent2.getInput()) === null || _embeddable$parent2$g === void 0 ? void 0 : _embeddable$parent2$g.hidePanelTitles) || Boolean((_embeddable$getInput2 = embeddable.getInput()) === null || _embeddable$getInput2 === void 0 ? void 0 : _embeddable$getInput2.hidePanelTitles)
          });
          this.refreshBadges();
          this.refreshNotifications();
        }
      });
    }
  }
  componentWillUnmount() {
    var _this$state$destroyEr, _this$state;
    this.mounted = false;
    this.subscription.unsubscribe();
    if (this.parentSubscription) {
      this.parentSubscription.unsubscribe();
    }
    (_this$state$destroyEr = (_this$state = this.state).destroyError) === null || _this$state$destroyEr === void 0 ? void 0 : _this$state$destroyEr.call(_this$state);
    this.props.embeddable.destroy();
  }
  render() {
    const viewOnlyMode = [_types.ViewMode.VIEW, _types.ViewMode.PRINT].includes(this.state.viewMode);
    const classes = (0, _classnames.default)('embPanel', {
      'embPanel--editing': !viewOnlyMode,
      'embPanel--loading': this.state.loading
    });
    const contentAttrs = {};
    if (this.state.loading) contentAttrs['data-loading'] = true;
    if (this.state.error) contentAttrs['data-error'] = true;
    const title = this.props.embeddable.getTitle();
    const description = this.props.embeddable.getDescription();
    const headerId = this.generateId();
    const selfStyledOptions = (0, _.isSelfStyledEmbeddable)(this.props.embeddable) ? this.props.embeddable.getSelfStyledOptions() : undefined;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      className: classes,
      "data-test-subj": "embeddablePanel",
      "data-test-embeddable-id": this.props.embeddable.id,
      paddingSize: "none",
      role: "figure",
      "aria-labelledby": headerId,
      hasShadow: this.props.showShadow
    }, !this.props.hideHeader && /*#__PURE__*/_react.default.createElement(_panel_header.PanelHeader, {
      getActionContextMenuPanel: this.getActionContextMenuPanel,
      hidePanelTitle: this.state.hidePanelTitle || !!(selfStyledOptions !== null && selfStyledOptions !== void 0 && selfStyledOptions.hideTitle),
      isViewMode: viewOnlyMode,
      customizePanel: 'customizePanel' in this.state.universalActions ? this.state.universalActions.customizePanel : undefined,
      closeContextMenu: this.state.closeContextMenu,
      title: title,
      description: description,
      index: this.props.index,
      badges: this.state.badges,
      notifications: this.state.notifications,
      embeddable: this.props.embeddable,
      headerId: headerId
    }), this.state.error && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      className: "eui-fullHeight embPanel__error",
      "data-test-subj": "embeddableError",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_embeddables.EmbeddableErrorHandler, {
      embeddable: this.props.embeddable,
      error: this.state.error
    }, error => /*#__PURE__*/_react.default.createElement(_embeddable_panel_error.EmbeddablePanelError, {
      editPanelAction: this.state.universalActions.editPanel,
      embeddable: this.props.embeddable,
      error: error
    })))), /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
      className: "embPanel__content",
      ref: this.embeddableRoot
    }, contentAttrs), this.state.node));
  }
  componentDidMount() {
    var _this$props$embeddabl;
    if (!this.embeddableRoot.current) {
      return;
    }
    this.subscription.add(this.props.embeddable.getOutput$().subscribe(output => {
      this.setState({
        error: output.error,
        loading: output.loading
      });
    }, error => {
      this.setState({
        error
      });
    }));
    const node = (_this$props$embeddabl = this.props.embeddable.render(this.embeddableRoot.current)) !== null && _this$props$embeddabl !== void 0 ? _this$props$embeddabl : undefined;
    if ((0, _std.isPromise)(node)) {
      node.then(resolved => this.setState({
        node: resolved
      }));
    } else {
      this.setState({
        node
      });
    }
  }
}
exports.EmbeddablePanel = EmbeddablePanel;