"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorEmbeddable = exports.ERROR_EMBEDDABLE_TYPE = void 0;
exports.isErrorEmbeddable = isErrorEmbeddable;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _embeddable_panel_error = require("../panel/embeddable_panel_error");
var _embeddable = require("./embeddable");
require("./error_embeddable.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ERROR_EMBEDDABLE_TYPE = 'error';
exports.ERROR_EMBEDDABLE_TYPE = ERROR_EMBEDDABLE_TYPE;
function isErrorEmbeddable(embeddable) {
  return Boolean(embeddable.fatalError || embeddable.error !== undefined);
}
class ErrorEmbeddable extends _embeddable.Embeddable {
  constructor(error, input, parent) {
    super(input, {}, parent);
    (0, _defineProperty2.default)(this, "type", ERROR_EMBEDDABLE_TYPE);
    (0, _defineProperty2.default)(this, "error", void 0);
    this.error = error;
  }
  reload() {}
  render() {
    const error = typeof this.error === 'string' ? {
      message: this.error,
      name: ''
    } : this.error;
    return /*#__PURE__*/_react.default.createElement(_embeddable_panel_error.EmbeddablePanelError, {
      embeddable: this,
      error: error
    });
  }
}
exports.ErrorEmbeddable = ErrorEmbeddable;