"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableRoot = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _std = require("@kbn/std");
var _embeddable_error_handler = require("./embeddable_error_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class EmbeddableRoot extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "root", void 0);
    (0, _defineProperty2.default)(this, "alreadyMounted", false);
    (0, _defineProperty2.default)(this, "updateNode", node => {
      if ((0, _std.isPromise)(node)) {
        node.then(this.updateNode);
        return;
      }
      this.setState({
        node
      });
    });
    this.root = /*#__PURE__*/_react.default.createRef();
    this.state = {};
  }
  componentDidMount() {
    var _this$root, _this$props$embeddabl;
    if (!((_this$root = this.root) !== null && _this$root !== void 0 && _this$root.current) || !this.props.embeddable) {
      return;
    }
    this.alreadyMounted = true;
    this.updateNode((_this$props$embeddabl = this.props.embeddable.render(this.root.current)) !== null && _this$props$embeddabl !== void 0 ? _this$props$embeddabl : undefined);
  }
  componentDidUpdate(prevProps) {
    var _this$root2;
    let justRendered = false;
    if ((_this$root2 = this.root) !== null && _this$root2 !== void 0 && _this$root2.current && this.props.embeddable && !this.alreadyMounted) {
      var _this$props$embeddabl2;
      this.alreadyMounted = true;
      this.updateNode((_this$props$embeddabl2 = this.props.embeddable.render(this.root.current)) !== null && _this$props$embeddabl2 !== void 0 ? _this$props$embeddabl2 : undefined);
      justRendered = true;
    }
    if (!justRendered && this.root && this.root.current && this.props.embeddable && this.alreadyMounted && this.props.input && (prevProps === null || prevProps === void 0 ? void 0 : prevProps.input) !== this.props.input) {
      this.props.embeddable.updateInput(this.props.input);
    }
  }
  shouldComponentUpdate({
    embeddable,
    error,
    input,
    loading
  }, {
    node
  }) {
    return Boolean(error !== this.props.error || loading !== this.props.loading || embeddable !== this.props.embeddable || this.root && this.root.current && embeddable && !this.alreadyMounted || input !== this.props.input || node !== this.state.node);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      ref: this.root
    }, this.state.node), this.props.loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": "embedSpinner"
    }), this.props.error && /*#__PURE__*/_react.default.createElement(_embeddable_error_handler.EmbeddableErrorHandler, {
      embeddable: this.props.embeddable,
      error: this.props.error
    }, ({
      message
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "embedError"
    }, message)));
  }
}
exports.EmbeddableRoot = EmbeddableRoot;