"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableChildPanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This component can be used by embeddable containers using react to easily render children. It waits
 * for the child to be initialized, showing a loading indicator until that is complete.
 */

class EmbeddableChildPanel extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "mounted", void 0);
    (0, _defineProperty2.default)(this, "embeddable", void 0);
    (0, _defineProperty2.default)(this, "subscription", new _rxjs.Subscription());
    this.state = {
      firstTimeLoading: true
    };
    this.mounted = false;
  }
  getEventStatus(output) {
    if (!(0, _lodash.isNil)(output.error)) {
      return 'error';
    } else if (output.rendered === true) {
      return 'rendered';
    } else if (output.loading === false) {
      return 'loaded';
    } else {
      return 'loading';
    }
  }
  async componentDidMount() {
    this.mounted = true;
    const {
      container
    } = this.props;
    this.embeddable = await container.untilEmbeddableLoaded(this.props.embeddableId);
    if (this.mounted) {
      var _this$subscription;
      let loadingStartTime = 0;
      (_this$subscription = this.subscription) === null || _this$subscription === void 0 ? void 0 : _this$subscription.add(this.embeddable.getOutput$().pipe(
      // Map loaded event properties
      (0, _operators.map)(output => {
        if (output.loading === true) {
          loadingStartTime = performance.now();
        }
        return {
          id: this.embeddable.id,
          status: this.getEventStatus(output),
          error: output.error
        };
      }),
      // Dedupe
      (0, _operators.distinct)(output => loadingStartTime + output.id + output.status + !!output.error),
      // Map loaded event properties
      (0, _operators.map)(output => {
        return {
          ...output,
          timeToEvent: performance.now() - loadingStartTime
        };
      })).subscribe(statusOutput => {
        if (this.props.onPanelStatusChange) {
          this.props.onPanelStatusChange(statusOutput);
        }
      }));
      this.setState({
        firstTimeLoading: false
      });
    }
  }
  componentWillUnmount() {
    this.mounted = false;
    if (this.subscription) {
      this.subscription.unsubscribe();
    }
  }
  render() {
    const {
      PanelComponent,
      index
    } = this.props;
    const classes = (0, _classnames.default)('embPanel', {
      'embPanel-isLoading': this.state.firstTimeLoading
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      className: classes
    }, this.state.firstTimeLoading || !this.embeddable ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "l",
      mono: true
    }) : /*#__PURE__*/_react.default.createElement(PanelComponent, {
      embeddable: this.embeddable,
      index: index
    }));
  }
}
exports.EmbeddableChildPanel = EmbeddableChildPanel;