"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelOptionsMenu = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PanelOptionsMenu = ({
  panelDescriptor,
  close,
  isViewMode,
  title
}) => {
  const [open, setOpen] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (!close) setOpen(false);
  }, [close]);
  const handleContextMenuClick = () => {
    setOpen(isOpen => !isOpen);
  };
  const handlePopoverClose = () => {
    setOpen(false);
  };
  const enhancedAriaLabel = _i18n.i18n.translate('embeddableApi.panel.optionsMenu.panelOptionsButtonEnhancedAriaLabel', {
    defaultMessage: 'Panel options for {title}',
    values: {
      title
    }
  });
  const ariaLabelWithoutTitle = _i18n.i18n.translate('embeddableApi.panel.optionsMenu.panelOptionsButtonAriaLabel', {
    defaultMessage: 'Panel options'
  });
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isViewMode ? 'boxesHorizontal' : 'gear',
    color: "text",
    className: "embPanel__optionsMenuButton",
    "aria-label": title ? enhancedAriaLabel : ariaLabelWithoutTitle,
    "data-test-subj": "embeddablePanelToggleMenuIcon",
    onClick: handleContextMenuClick
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: open,
    closePopover: handlePopoverClose,
    panelPaddingSize: "none",
    anchorPosition: "downRight",
    "data-test-subj": open ? 'embeddablePanelContextMenuOpen' : 'embeddablePanelContextMenuClosed'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: "mainMenu",
    panels: panelDescriptor ? [panelDescriptor] : []
  }));
};
exports.PanelOptionsMenu = PanelOptionsMenu;