"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableActionStorage = void 0;
var _public = require("@kbn/ui-actions-enhanced-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EmbeddableActionStorage extends _public.UiActionsEnhancedAbstractActionStorage {
  constructor(embbeddable) {
    super();
    this.embbeddable = embbeddable;
  }
  put(input, events) {
    var _input$enhancements;
    this.embbeddable.updateInput({
      enhancements: {
        ...(input.enhancements || {}),
        dynamicActions: {
          ...(((_input$enhancements = input.enhancements) === null || _input$enhancements === void 0 ? void 0 : _input$enhancements.dynamicActions) || {}),
          events
        }
      }
    });
  }
  async create(event) {
    const input = this.embbeddable.getInput();
    const events = this.getEventsFromEmbeddable();
    const exists = !!events.find(({
      eventId
    }) => eventId === event.eventId);
    if (exists) {
      throw new Error(`[EEXIST]: Event with [eventId = ${event.eventId}] already exists on ` + `[embeddable.id = ${input.id}, embeddable.title = ${input.title}].`);
    }
    this.put(input, [...events, event]);
  }
  async update(event) {
    const input = this.embbeddable.getInput();
    const events = this.getEventsFromEmbeddable();
    const index = events.findIndex(({
      eventId
    }) => eventId === event.eventId);
    if (index === -1) {
      throw new Error(`[ENOENT]: Event with [eventId = ${event.eventId}] could not be ` + `updated as it does not exist in ` + `[embeddable.id = ${input.id}, embeddable.title = ${input.title}].`);
    }
    this.put(input, [...events.slice(0, index), event, ...events.slice(index + 1)]);
  }
  async remove(eventId) {
    const input = this.embbeddable.getInput();
    const events = this.getEventsFromEmbeddable();
    const index = events.findIndex(event => eventId === event.eventId);
    if (index === -1) {
      throw new Error(`[ENOENT]: Event with [eventId = ${eventId}] could not be ` + `removed as it does not exist in ` + `[embeddable.id = ${input.id}, embeddable.title = ${input.title}].`);
    }
    this.put(input, [...events.slice(0, index), ...events.slice(index + 1)]);
  }
  async read(eventId) {
    const input = this.embbeddable.getInput();
    const events = this.getEventsFromEmbeddable();
    const event = events.find(ev => eventId === ev.eventId);
    if (!event) {
      throw new Error(`[ENOENT]: Event with [eventId = ${eventId}] could not be found in ` + `[embeddable.id = ${input.id}, embeddable.title = ${input.title}].`);
    }
    return event;
  }
  async list() {
    return this.getEventsFromEmbeddable();
  }
  getEventsFromEmbeddable() {
    var _input$enhancements2, _input$enhancements2$;
    const input = this.embbeddable.getInput();
    const events = ((_input$enhancements2 = input.enhancements) === null || _input$enhancements2 === void 0 ? void 0 : (_input$enhancements2$ = _input$enhancements2.dynamicActions) === null || _input$enhancements2$ === void 0 ? void 0 : _input$enhancements2$.events) || [];
    return this.migrate(events);
  }

  // TODO: https://github.com/elastic/kibana/issues/148005
  // Migration implementation should use registry
  // Action factories implementations should register own migrations
  migrate(events) {
    return events.map(event => {
      // Initially dashboard drilldown relied on VALUE_CLICK & RANGE_SELECT
      if (event.action.factoryId === 'DASHBOARD_TO_DASHBOARD_DRILLDOWN') {
        const migratedTriggers = event.triggers.filter(t => t !== _public2.VALUE_CLICK_TRIGGER && t !== _public2.SELECT_RANGE_TRIGGER);
        if (migratedTriggers.length !== event.triggers.length && !migratedTriggers.includes(`FILTER_TRIGGER`)) {
          migratedTriggers.push(`FILTER_TRIGGER`);
        }
        return {
          ...event,
          triggers: migratedTriggers
        };
      }
      return event;
    });
  }
}
exports.EmbeddableActionStorage = EmbeddableActionStorage;