"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.txtOneDrilldown = exports.txtManyDrilldowns = exports.PanelNotificationsAction = exports.ACTION_PANEL_NOTIFICATIONS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const txtOneDrilldown = _i18n.i18n.translate('xpack.embeddableEnhanced.actions.panelNotifications.oneDrilldown', {
  defaultMessage: 'Panel has 1 drilldown'
});
exports.txtOneDrilldown = txtOneDrilldown;
const txtManyDrilldowns = count => _i18n.i18n.translate('xpack.embeddableEnhanced.actions.panelNotifications.manyDrilldowns', {
  defaultMessage: 'Panel has {count} drilldowns',
  values: {
    count: String(count)
  }
});
exports.txtManyDrilldowns = txtManyDrilldowns;
const ACTION_PANEL_NOTIFICATIONS = 'ACTION_PANEL_NOTIFICATIONS';

/**
 * This action renders in "edit" mode number of events (dynamic action) a panel
 * has attached to it.
 */
exports.ACTION_PANEL_NOTIFICATIONS = ACTION_PANEL_NOTIFICATIONS;
class PanelNotificationsAction {
  constructor() {
    (0, _defineProperty2.default)(this, "id", ACTION_PANEL_NOTIFICATIONS);
    (0, _defineProperty2.default)(this, "getDisplayName", ({
      embeddable
    }) => {
      return String(this.getEventCount(embeddable));
    });
    (0, _defineProperty2.default)(this, "getDisplayNameTooltip", ({
      embeddable
    }) => {
      const count = this.getEventCount(embeddable);
      return !count ? '' : count === 1 ? txtOneDrilldown : txtManyDrilldowns(count);
    });
    (0, _defineProperty2.default)(this, "isCompatible", async ({
      embeddable
    }) => {
      if (embeddable.getInput().viewMode !== _public.ViewMode.EDIT) return false;
      return this.getEventCount(embeddable) > 0;
    });
    (0, _defineProperty2.default)(this, "execute", async () => {});
  }
  getEventCount(embeddable) {
    return embeddable.enhancements.dynamicActions.state.get().events.length;
  }
}
exports.PanelNotificationsAction = PanelNotificationsAction;