"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexMappingsRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _lib = require("../lib");
var _build_response = require("../lib/build_response");
var _constants = require("../../common/constants");
var _get_index_mappings = require("../schemas/get_index_mappings");
var _common = require("../schemas/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndexMappingsRoute = router => {
  router.get({
    path: _constants.GET_INDEX_MAPPINGS,
    validate: {
      params: (0, _common.buildRouteValidation)(_get_index_mappings.GetIndexMappingsParams)
    }
  }, async (context, request, response) => {
    const resp = (0, _build_response.buildResponse)(response);
    try {
      const {
        client
      } = (await context.core).elasticsearch;
      const decodedIndexName = decodeURIComponent(request.params.pattern);
      const mappings = await (0, _lib.fetchMappings)(client, decodedIndexName);
      return response.ok({
        body: mappings
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return resp.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getIndexMappingsRoute = getIndexMappingsRoute;