"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getILMExplainRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../common/constants");
var _lib = require("../lib");
var _build_response = require("../lib/build_response");
var _common = require("../schemas/common");
var _get_ilm_explain = require("../schemas/get_ilm_explain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getILMExplainRoute = router => {
  router.get({
    path: _constants.GET_ILM_EXPLAIN,
    validate: {
      params: (0, _common.buildRouteValidation)(_get_ilm_explain.GetILMExplainParams)
    }
  }, async (context, request, response) => {
    const resp = (0, _build_response.buildResponse)(response);
    try {
      const {
        client
      } = (await context.core).elasticsearch;
      const decodedIndexName = decodeURIComponent(request.params.pattern);
      const ilmExplain = await (0, _lib.fetchILMExplain)(client, decodedIndexName);
      return response.ok({
        body: ilmExplain.indices
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return resp.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getILMExplainRoute = getILMExplainRoute;