"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverServerPlugin = void 0;
var _common = require("@kbn/kibana-utils-plugin/common");
var _locator = require("../common/locator");
var _capabilities_provider = require("./capabilities_provider");
var _locator2 = require("./locator");
var _sample_data = require("./sample_data");
var _ui_settings = require("./ui_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DiscoverServerPlugin {
  setup(core, plugins) {
    core.capabilities.registerProvider(_capabilities_provider.capabilitiesProvider);
    core.uiSettings.register((0, _ui_settings.getUiSettings)(core.docLinks));
    if (plugins.home) {
      (0, _sample_data.registerSampleData)(plugins.home.sampleData);
    }
    if (plugins.share) {
      plugins.share.url.locators.create(new _locator.DiscoverAppLocatorDefinition({
        useHash: false,
        setStateToKbnUrl: _common.setStateToKbnUrl
      }));
    }
    return {};
  }
  start(core, deps) {
    return {
      locator: (0, _locator2.initializeLocatorServices)(core, deps)
    };
  }
  stop() {}
}
exports.DiscoverServerPlugin = DiscoverServerPlugin;