"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRowsPerPageOptions = exports.getDefaultRowsPerPage = void 0;
var _lodash = require("lodash");
var _constants = require("../../common/constants");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getRowsPerPageOptions = currentRowsPerPage => {
  return (0, _lodash.sortBy)((0, _lodash.uniq)(typeof currentRowsPerPage === 'number' && currentRowsPerPage > 0 ? [..._constants.ROWS_PER_PAGE_OPTIONS, currentRowsPerPage] : _constants.ROWS_PER_PAGE_OPTIONS));
};
exports.getRowsPerPageOptions = getRowsPerPageOptions;
const getDefaultRowsPerPage = uiSettings => {
  return parseInt(uiSettings.get(_common.SAMPLE_ROWS_PER_PAGE_SETTING), 10) || _constants.DEFAULT_ROWS_PER_PAGE;
};
exports.getDefaultRowsPerPage = getDefaultRowsPerPage;