"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateStoredRowHeight = exports.getStoredRowHeight = void 0;
var _validate_row_height = require("./validate_row_height");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ROW_HEIGHT_KEY = 'discover:dataGridRowHeight';
const getStoredRowHeight = storage => {
  const entry = storage.get(ROW_HEIGHT_KEY);
  if (typeof entry === 'object' && entry !== null && (0, _validate_row_height.isValidRowHeight)(entry.previousRowHeight) && (0, _validate_row_height.isValidRowHeight)(entry.previousConfigRowHeight)) {
    return entry;
  }
  return null;
};
exports.getStoredRowHeight = getStoredRowHeight;
const updateStoredRowHeight = (newRowHeight, configRowHeight, storage) => {
  storage.set(ROW_HEIGHT_KEY, {
    previousRowHeight: newRowHeight,
    previousConfigRowHeight: configRowHeight
  });
};
exports.updateStoredRowHeight = updateStoredRowHeight;