"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.popularizeField = popularizeField;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function popularizeField(dataView, fieldName, DataViewsService, capabilities) {
  var _capabilities$indexPa;
  if (!dataView.id || !(capabilities !== null && capabilities !== void 0 && (_capabilities$indexPa = capabilities.indexPatterns) !== null && _capabilities$indexPa !== void 0 && _capabilities$indexPa.save)) return;
  const field = dataView.fields.getByName(fieldName);
  if (!field) {
    return;
  }
  field.count++;
  if (!dataView.isPersisted()) {
    return;
  }

  // Catch 409 errors caused by user adding columns in a higher frequency that the changes can be persisted to Elasticsearch
  try {
    await DataViewsService.updateSavedObject(dataView, 0, true);
    // eslint-disable-next-line no-empty
  } catch {}
}