"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShouldShowFieldHandler = void 0;
var _public = require("@kbn/data-views-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Returns a function for checking whether we should display a field in the Documents column of the data table
 * If showMultiFields is set to false, it filters out multifields that have a parent, to prevent entries for multifields
 * like this: field, field.keyword, field.whatever
 * @param fields
 * @param dataView
 * @param showMultiFields
 */
const getShouldShowFieldHandler = (fields, dataView, showMultiFields) => {
  if (showMultiFields) {
    return () => true;
  }
  const fieldsToShowMap = new Map();
  fields.forEach(fieldName => {
    fieldsToShowMap.set(fieldName, canShowFieldInTable(fieldName, dataView));
  });
  return fieldName => {
    const result = fieldsToShowMap.get(fieldName);
    if (!result) {
      return true; // for unmapped
    }
    // if the parent of the multi field was not in `fields` array then show the multi field too
    return result.show || !!result.parentName && !fieldsToShowMap.has(result.parentName);
  };
};
exports.getShouldShowFieldHandler = getShouldShowFieldHandler;
const canShowFieldInTable = (fieldName, dataView) => {
  var _subTypeMulti$multi;
  const mapped = dataView.fields.getByName(fieldName);
  if (!mapped) {
    return {
      show: true
    };
  }
  const subTypeMulti = (0, _public.getFieldSubtypeMulti)(mapped.spec);
  const isMultiField = Boolean(subTypeMulti === null || subTypeMulti === void 0 ? void 0 : subTypeMulti.multi);
  return {
    show: !isMultiField,
    parentName: subTypeMulti === null || subTypeMulti === void 0 ? void 0 : (_subTypeMulti$multi = subTypeMulti.multi) === null || _subTypeMulti$multi === void 0 ? void 0 : _subTypeMulti$multi.parent
  };
};