"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSharingData = getSharingData;
exports.showPublicUrlSwitch = void 0;
var _discover_app_state_container = require("../application/main/services/discover_app_state_container");
var _sorting = require("./sorting");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Preparing data to share the current state as link or CSV/Report
 */
async function getSharingData(currentSearchSource, state, services) {
  const {
    uiSettings: config,
    data
  } = services;
  const searchSource = currentSearchSource.createCopy();
  const index = searchSource.getField('index');
  let existingFilter = searchSource.getField('filter');
  searchSource.setField('sort', (0, _sorting.getSortForSearchSource)(state.sort, index, config.get(_common.SORT_DEFAULT_ORDER_SETTING)));
  searchSource.removeField('filter');
  searchSource.removeField('highlight');
  searchSource.removeField('highlightAll');
  searchSource.removeField('aggs');
  searchSource.removeField('size');

  // Columns that the user has selected in the saved search
  let columns = state.columns || [];
  if (columns && columns.length > 0) {
    // conditionally add the time field column:
    let timeFieldName;
    const hideTimeColumn = config.get(_common.DOC_HIDE_TIME_COLUMN_SETTING);
    if (!hideTimeColumn && index && index.timeFieldName) {
      timeFieldName = index.timeFieldName;
    }
    if (timeFieldName && !columns.includes(timeFieldName)) {
      columns = [timeFieldName, ...columns];
    }
  }
  const absoluteTimeFilter = data.query.timefilter.timefilter.createFilter(index);
  const relativeTimeFilter = data.query.timefilter.timefilter.createRelativeFilter(index);
  return {
    getSearchSource: absoluteTime => {
      const timeFilter = absoluteTime ? absoluteTimeFilter : relativeTimeFilter;

      // remove timeFilter from existing filter
      if (Array.isArray(existingFilter)) {
        existingFilter = existingFilter.filter(current => !(0, _discover_app_state_container.isEqualFilters)(current, absoluteTimeFilter));
      } else if ((0, _discover_app_state_container.isEqualFilters)(existingFilter, absoluteTimeFilter)) {
        existingFilter = undefined;
      }
      if (existingFilter && timeFilter) {
        searchSource.setField('filter', Array.isArray(existingFilter) ? [timeFilter, ...existingFilter] : [timeFilter, existingFilter]);
      } else {
        const filter = timeFilter || existingFilter;
        searchSource.setField('filter', filter);
      }

      /*
       * For downstream querying performance, the searchSource object must have fields set.
       * Otherwise, the requests will ask for all fields, even if only a few are really needed.
       * Discover does not set fields, since having all fields is needed for the UI.
       */
      const useFieldsApi = !config.get(_common.SEARCH_FIELDS_FROM_SOURCE);
      if (useFieldsApi) {
        searchSource.removeField('fieldsFromSource');
        const fields = columns.length ? columns.map(field => ({
          field,
          include_unmapped: 'true'
        })) : [{
          field: '*',
          include_unmapped: 'true'
        }];
        searchSource.setField('fields', fields);
      }
      return searchSource.getSerializedFields(true);
    },
    columns
  };
}
const showPublicUrlSwitch = anonymousUserCapabilities => {
  if (!anonymousUserCapabilities.discover) return false;
  const discover = anonymousUserCapabilities.discover;
  return !!discover.show;
};
exports.showPublicUrlSwitch = showPublicUrlSwitch;