"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertValueToString = exports.convertNameToString = void 0;
var _common = require("@kbn/data-plugin/common");
var _format_value = require("./format_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const convertValueToString = ({
  rowIndex,
  rows,
  columnId,
  dataView,
  fieldFormats,
  options
}) => {
  var _options$compatibleWi, _options$compatibleWi2;
  if (!rows[rowIndex]) {
    return {
      formattedString: '',
      withFormula: false
    };
  }
  const rowFlattened = rows[rowIndex].flattened;
  const value = rowFlattened === null || rowFlattened === void 0 ? void 0 : rowFlattened[columnId];
  const field = dataView.fields.getByName(columnId);
  const valuesArray = Array.isArray(value) ? value : [value];
  const disableMultiline = (_options$compatibleWi = options === null || options === void 0 ? void 0 : options.compatibleWithCSV) !== null && _options$compatibleWi !== void 0 ? _options$compatibleWi : false;
  const enableEscapingForValue = (_options$compatibleWi2 = options === null || options === void 0 ? void 0 : options.compatibleWithCSV) !== null && _options$compatibleWi2 !== void 0 ? _options$compatibleWi2 : false;
  if ((field === null || field === void 0 ? void 0 : field.type) === '_source') {
    return {
      formattedString: stringify(rowFlattened, disableMultiline),
      withFormula: false
    };
  }
  let withFormula = false;
  const formatted = valuesArray.map(subValue => {
    const formattedValue = (0, _format_value.formatFieldValue)(subValue, rows[rowIndex].raw, fieldFormats, dataView, field, 'text', {
      skipFormattingInStringifiedJSON: disableMultiline
    });
    if (typeof formattedValue === 'string') {
      withFormula = withFormula || (0, _common.cellHasFormulas)(formattedValue);
      return enableEscapingForValue ? escapeFormattedValue(formattedValue) : formattedValue;
    }
    return stringify(formattedValue, disableMultiline) || '';
  }).join(', ');
  return {
    formattedString: formatted,
    withFormula
  };
};
exports.convertValueToString = convertValueToString;
const convertNameToString = name => {
  return {
    formattedString: escapeFormattedValue(name),
    withFormula: (0, _common.cellHasFormulas)(name)
  };
};
exports.convertNameToString = convertNameToString;
const stringify = (val, disableMultiline) => {
  // it can wrap "strings" with quotes
  return disableMultiline ? JSON.stringify(val) : JSON.stringify(val, null, 2);
};
const escapeValueFn = (0, _common.createEscapeValue)(true, true);
const escapeFormattedValue = formattedValue => {
  return escapeValueFn(formattedValue);
};