"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRootBreadcrumbs = getRootBreadcrumbs;
exports.getSavedSearchBreadcrumbs = getSavedSearchBreadcrumbs;
exports.setBreadcrumbsTitle = setBreadcrumbsTitle;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getRootBreadcrumbs(breadcrumb) {
  return [{
    text: _i18n.i18n.translate('discover.rootBreadcrumb', {
      defaultMessage: 'Discover'
    }),
    href: breadcrumb || '#/'
  }];
}
function getSavedSearchBreadcrumbs(id) {
  return [...getRootBreadcrumbs(), {
    text: id
  }];
}

/**
 * Helper function to set the Discover's breadcrumb
 * if there's an active savedSearch, its title is appended
 */
function setBreadcrumbsTitle(savedSearch, chrome) {
  const discoverBreadcrumbsTitle = _i18n.i18n.translate('discover.discoverBreadcrumbTitle', {
    defaultMessage: 'Discover'
  });
  if (savedSearch.id && savedSearch.title) {
    chrome.setBreadcrumbs([{
      text: discoverBreadcrumbsTitle,
      href: '#/'
    }, {
      text: savedSearch.title
    }]);
  } else {
    chrome.setBreadcrumbs([{
      text: discoverBreadcrumbsTitle
    }]);
  }
}