"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocViewsRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DocViewsRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "docViews", []);
  }
  /**
   * Extends and adds the given doc view to the registry array
   */
  addDocView(docViewRaw) {
    const docView = typeof docViewRaw === 'function' ? docViewRaw() : docViewRaw;
    if (typeof docView.shouldShow !== 'function') {
      docView.shouldShow = () => true;
    }
    this.docViews.push(docView);
  }
  /**
   * Returns a sorted array of doc_views for rendering tabs
   */
  getDocViewsSorted(hit) {
    return this.docViews.filter(docView => docView.shouldShow(hit)).sort((a, b) => Number(a.order) > Number(b.order) ? 1 : -1);
  }
}
exports.DocViewsRegistry = DocViewsRegistry;