"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHeight = getHeight;
var _monaco = require("@kbn/monaco");
var _source = require("./source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getHeight(editor, useDocExplorer) {
  const editorElement = editor === null || editor === void 0 ? void 0 : editor.getDomNode();
  if (!editorElement) {
    return 0;
  }
  let result;
  if (useDocExplorer) {
    // assign a good height filling the available space of the document flyout
    const position = editorElement.getBoundingClientRect();
    result = window.innerHeight - position.top - _source.MARGIN_BOTTOM;
  } else {
    var _editor$getModel;
    // takes care of the classic table, display a maximum of 500 lines
    // why not display it all? Due to performance issues when the browser needs to render it all
    const lineHeight = editor.getOption(_monaco.monaco.editor.EditorOption.lineHeight);
    const lineCount = ((_editor$getModel = editor.getModel()) === null || _editor$getModel === void 0 ? void 0 : _editor$getModel.getLineCount()) || 1;
    const displayedLineCount = lineCount > _source.MAX_LINES_CLASSIC_TABLE ? _source.MAX_LINES_CLASSIC_TABLE : lineCount;
    result = editor.getTopForLineNumber(displayedLineCount + 1) + lineHeight;
  }
  return result > 0 ? result : 0;
}