"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _common = require("../common");
var _doc_views_registry = require("./services/doc_views/doc_views_registry");
var _kibana_services = require("./kibana_services");
var _register_feature = require("./register_feature");
var _build_services = require("./build_services");
var _embeddable = require("./embeddable");
var _components = require("./components");
var _view_saved_search_action = require("./embeddable/view_saved_search_action");
var _truncate_styles = require("./utils/truncate_styles");
var _use_discover_services = require("./hooks/use_discover_services");
var _initialize_kbn_url_tracking = require("./utils/initialize_kbn_url_tracking");
var _locator = require("./application/context/services/locator");
var _locator2 = require("./application/doc/locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const DocViewerLegacyTable = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./services/doc_views/components/doc_viewer_table/legacy'))));
const DocViewerTable = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./services/doc_views/components/doc_viewer_table'))));
const SourceViewer = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./services/doc_views/components/doc_viewer_source'))));

/**
 * @public
 */

/**
 * Contains Discover, one of the oldest parts of Kibana
 * Discover provides embeddables for Dashboards
 */
class DiscoverPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "appStateUpdater", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "docViewsRegistry", null);
    (0, _defineProperty2.default)(this, "stopUrlTracking", undefined);
    (0, _defineProperty2.default)(this, "locator", void 0);
    (0, _defineProperty2.default)(this, "contextLocator", void 0);
    (0, _defineProperty2.default)(this, "singleDocLocator", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core, plugins) {
    const baseUrl = core.http.basePath.prepend('/app/discover');
    const isDev = this.initializerContext.env.mode.dev;
    if (plugins.share) {
      const useHash = core.uiSettings.get('state:storeInSessionStorage');
      this.locator = plugins.share.url.locators.create(new _common.DiscoverAppLocatorDefinition({
        useHash,
        setStateToKbnUrl: _public2.setStateToKbnUrl
      }));
      this.contextLocator = plugins.share.url.locators.create(new _locator.DiscoverContextAppLocatorDefinition({
        useHash
      }));
      this.singleDocLocator = plugins.share.url.locators.create(new _locator2.DiscoverSingleDocLocatorDefinition());
    }
    this.docViewsRegistry = new _doc_views_registry.DocViewsRegistry();
    (0, _kibana_services.setDocViewsRegistry)(this.docViewsRegistry);
    this.docViewsRegistry.addDocView({
      title: _i18n.i18n.translate('discover.docViews.table.tableTitle', {
        defaultMessage: 'Table'
      }),
      order: 10,
      component: props => {
        // eslint-disable-next-line react-hooks/rules-of-hooks
        const services = (0, _use_discover_services.useDiscoverServices)();
        const DocView = services.uiSettings.get(_common.DOC_TABLE_LEGACY) ? DocViewerLegacyTable : DocViewerTable;
        return /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
          fallback: /*#__PURE__*/_react.default.createElement(_components.DeferredSpinner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, null))
        }, /*#__PURE__*/_react.default.createElement(DocView, props));
      }
    });
    this.docViewsRegistry.addDocView({
      title: _i18n.i18n.translate('discover.docViews.json.jsonTitle', {
        defaultMessage: 'JSON'
      }),
      order: 20,
      component: ({
        hit,
        dataView
      }) => /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
        fallback: /*#__PURE__*/_react.default.createElement(_components.DeferredSpinner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, null))
      }, /*#__PURE__*/_react.default.createElement(SourceViewer, {
        index: hit.raw._index,
        id: hit.raw._id,
        dataView: dataView,
        hasLineNumbers: true
      }))
    });
    const {
      setTrackedUrl,
      restorePreviousUrl,
      stopUrlTracker,
      appMounted,
      appUnMounted,
      setTrackingEnabled
    } = (0, _initialize_kbn_url_tracking.initializeKbnUrlTracking)(baseUrl, core, this.appStateUpdater, plugins);
    (0, _kibana_services.setUrlTracker)({
      setTrackedUrl,
      restorePreviousUrl,
      setTrackingEnabled
    });
    this.stopUrlTracking = () => {
      stopUrlTracker();
    };
    core.application.register({
      id: _common.PLUGIN_ID,
      title: 'Discover',
      updater$: this.appStateUpdater.asObservable(),
      order: 1000,
      euiIconType: 'logoKibana',
      defaultPath: '#/',
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      mount: async params => {
        const [coreStart, discoverStartPlugins] = await core.getStartServices();
        (0, _kibana_services.setScopedHistory)(params.history);
        (0, _kibana_services.setHeaderActionMenuMounter)(params.setHeaderActionMenu);
        (0, _kibana_services.syncHistoryLocations)();
        appMounted();

        // dispatch synthetic hash change event to update hash history objects
        // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
        const unlistenParentHistory = params.history.listen(() => {
          window.dispatchEvent(new HashChangeEvent('hashchange'));
        });
        const services = (0, _build_services.buildServices)(coreStart, discoverStartPlugins, this.initializerContext, this.locator, this.contextLocator, this.singleDocLocator);

        // make sure the data view list is up to date
        await discoverStartPlugins.dataViews.clearCache();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        // FIXME: Temporarily hide overflow-y in Discover app when Field Stats table is shown
        // due to EUI bug https://github.com/elastic/eui/pull/5152
        params.element.classList.add('dscAppWrapper');
        const unmount = renderApp(params.element, services, isDev);
        return () => {
          unlistenParentHistory();
          unmount();
          appUnMounted();
        };
      }
    });
    plugins.urlForwarding.forwardApp('doc', 'discover', path => {
      return `#${path}`;
    });
    plugins.urlForwarding.forwardApp('context', 'discover', path => {
      const urlParts = path.split('/');
      // take care of urls containing legacy url, those split in the following way
      // ["", "context", indexPatternId, _type, id + params]
      if (urlParts[4]) {
        // remove _type part
        const newPath = [...urlParts.slice(0, 3), ...urlParts.slice(4)].join('/');
        return `#${newPath}`;
      }
      return `#${path}`;
    });
    plugins.urlForwarding.forwardApp('discover', 'discover', path => {
      const [, id, tail] = /discover\/([^\?]+)(.*)/.exec(path) || [];
      if (!id) {
        return `#${path.replace('/discover', '') || '/'}`;
      }
      return `#/view/${id}${tail || ''}`;
    });
    if (plugins.home) {
      (0, _register_feature.registerFeature)(plugins.home);
    }
    this.registerEmbeddable(core, plugins);
    return {
      docViews: {
        addDocView: this.docViewsRegistry.addDocView.bind(this.docViewsRegistry)
      },
      locator: this.locator
    };
  }
  start(core, plugins) {
    // we need to register the application service at setup, but to render it
    // there are some start dependencies necessary, for this reason
    // initializeServices are assigned at start and used
    // when the application/embeddable is mounted

    const {
      uiActions
    } = plugins;
    const viewSavedSearchAction = new _view_saved_search_action.ViewSavedSearchAction(core.application);
    uiActions.addTriggerAction('CONTEXT_MENU_TRIGGER', viewSavedSearchAction);
    (0, _kibana_services.setUiActions)(plugins.uiActions);
    (0, _truncate_styles.injectTruncateStyles)(core.uiSettings.get(_common.TRUNCATE_MAX_HEIGHT));
    return {
      locator: this.locator
    };
  }
  stop() {
    if (this.stopUrlTracking) {
      this.stopUrlTracking();
    }
  }
  registerEmbeddable(core, plugins) {
    const getStartServices = async () => {
      const [coreStart, deps] = await core.getStartServices();
      return {
        executeTriggerActions: deps.uiActions.executeTriggerActions,
        isEditable: () => coreStart.application.capabilities.discover.save
      };
    };
    const getDiscoverServices = async () => {
      const [coreStart, discoverStartPlugins] = await core.getStartServices();
      return (0, _build_services.buildServices)(coreStart, discoverStartPlugins, this.initializerContext, this.locator, this.contextLocator, this.singleDocLocator);
    };
    const factory = new _embeddable.SearchEmbeddableFactory(getStartServices, getDiscoverServices);
    plugins.embeddable.registerEmbeddableFactory(factory.type, factory);
  }
}
exports.DiscoverPlugin = DiscoverPlugin;