"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumns = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _columns = require("../components/doc_table/actions/columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useColumns = ({
  capabilities,
  config,
  dataView,
  dataViews,
  setAppState,
  useNewFieldsApi,
  columns,
  sort
}) => {
  const [usedColumns, setUsedColumns] = (0, _react.useState)(getColumns(columns, useNewFieldsApi));
  (0, _react.useEffect)(() => {
    const nextColumns = getColumns(columns, useNewFieldsApi);
    if ((0, _lodash.isEqual)(usedColumns, nextColumns)) {
      return;
    }
    setUsedColumns(nextColumns);
  }, [columns, useNewFieldsApi, usedColumns]);
  const {
    onAddColumn,
    onRemoveColumn,
    onSetColumns,
    onMoveColumn
  } = (0, _react.useMemo)(() => (0, _columns.getStateColumnActions)({
    capabilities,
    config,
    dataView,
    dataViews,
    setAppState,
    useNewFieldsApi,
    columns: usedColumns,
    sort
  }), [capabilities, config, dataView, dataViews, setAppState, sort, useNewFieldsApi, usedColumns]);
  return {
    columns: usedColumns,
    onAddColumn,
    onRemoveColumn,
    onMoveColumn,
    onSetColumns
  };
};
exports.useColumns = useColumns;
function getColumns(columns, useNewFieldsApi) {
  if (!columns) {
    return [];
  }
  return useNewFieldsApi ? columns.filter(col => col !== '_source') : columns;
}