"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/saved-search-plugin/public");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class SearchEmbeddableFactory {
  constructor(getStartServices, getDiscoverServices) {
    (0, _defineProperty2.default)(this, "type", _constants.SEARCH_EMBEDDABLE_TYPE);
    (0, _defineProperty2.default)(this, "savedObjectMetaData", {
      name: _i18n.i18n.translate('discover.savedSearch.savedObjectName', {
        defaultMessage: 'Saved search'
      }),
      type: 'search',
      getIconForSavedObject: () => 'discoverApp'
    });
    (0, _defineProperty2.default)(this, "isEditable", async () => {
      return (await this.getStartServices()).isEditable();
    });
    (0, _defineProperty2.default)(this, "createFromSavedObject", async (savedObjectId, input, parent) => {
      const services = await this.getDiscoverServices();
      const filterManager = services.filterManager;
      const url = (0, _public2.getSavedSearchUrl)(savedObjectId);
      const editUrl = services.addBasePath(`/app/discover${url}`);
      try {
        const savedSearch = await (0, _public2.getSavedSearch)(savedObjectId, {
          search: services.data.search,
          savedObjectsClient: services.core.savedObjects.client,
          spaces: services.spaces,
          savedObjectsTagging: services.savedObjectsTagging
        });
        await (0, _public2.throwErrorOnSavedSearchUrlConflict)(savedSearch);
        const dataView = savedSearch.searchSource.getField('index');
        const {
          executeTriggerActions
        } = await this.getStartServices();
        const {
          SavedSearchEmbeddable: SavedSearchEmbeddableClass
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./saved_search_embeddable')));
        return new SavedSearchEmbeddableClass({
          savedSearch,
          editUrl,
          editPath: url,
          filterManager,
          editable: services.capabilities.discover.save,
          indexPatterns: dataView ? [dataView] : [],
          services
        }, input, executeTriggerActions, parent);
      } catch (e) {
        console.error(e); // eslint-disable-line no-console
        return new _public.ErrorEmbeddable(e, input, parent);
      }
    });
    this.getStartServices = getStartServices;
    this.getDiscoverServices = getDiscoverServices;
  }
  canCreateNew() {
    return false;
  }
  getDisplayName() {
    return _i18n.i18n.translate('discover.embeddable.search.displayName', {
      defaultMessage: 'search'
    });
  }
  async create(input) {
    return new _public.ErrorEmbeddable('Saved searches can only be created from a saved object', input);
  }
}
exports.SearchEmbeddableFactory = SearchEmbeddableFactory;