"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchEmbeddableComponent = SavedSearchEmbeddableComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _saved_search_grid = require("./saved_search_grid");
var _create_doc_table_embeddable = require("../components/doc_table/create_doc_table_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverDocTableEmbeddableMemoized = /*#__PURE__*/_react.default.memo(_create_doc_table_embeddable.DiscoverDocTableEmbeddable);
const DiscoverGridEmbeddableMemoized = /*#__PURE__*/_react.default.memo(_saved_search_grid.DiscoverGridEmbeddable);
function SavedSearchEmbeddableComponent({
  searchProps,
  useLegacyTable
}) {
  if (useLegacyTable) {
    return /*#__PURE__*/_react.default.createElement(DiscoverDocTableEmbeddableMemoized, searchProps);
  }
  return /*#__PURE__*/_react.default.createElement(DiscoverGridEmbeddableMemoized, (0, _extends2.default)({}, searchProps, {
    showFullScreenButton: false,
    className: "dscDiscoverGrid"
  }));
}