"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonCodeEditorCommon = exports.JSONCodeEditorCommonMemoized = void 0;
require("./json_code_editor.scss");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const codeEditorAriaLabel = _i18n.i18n.translate('discover.json.codeEditorAriaLabel', {
  defaultMessage: 'Read only JSON view of an elasticsearch document'
});
const copyToClipboardLabel = _i18n.i18n.translate('discover.json.copyToClipboardLabel', {
  defaultMessage: 'Copy to clipboard'
});
const JsonCodeEditorCommon = ({
  jsonValue,
  width,
  height,
  hasLineNumbers,
  onEditorDidMount,
  hideCopyButton
}) => {
  if (jsonValue === '') {
    return null;
  }
  const codeEditor = /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    languageId: _monaco.XJsonLang.ID,
    width: width,
    height: height,
    value: jsonValue || '',
    editorDidMount: onEditorDidMount,
    "aria-label": codeEditorAriaLabel,
    options: {
      automaticLayout: true,
      fontSize: 12,
      lineNumbers: hasLineNumbers ? 'on' : 'off',
      minimap: {
        enabled: false
      },
      overviewRulerBorder: false,
      readOnly: true,
      scrollbar: {
        alwaysConsumeMouseWheel: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent'
    }
  });
  if (hideCopyButton) {
    return codeEditor;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "dscJsonCodeEditor",
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: jsonValue
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    iconType: "copyClipboard",
    onClick: copy
  }, copyToClipboardLabel)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, codeEditor));
};
exports.JsonCodeEditorCommon = JsonCodeEditorCommon;
const JSONCodeEditorCommonMemoized = /*#__PURE__*/_react.default.memo(props => {
  return /*#__PURE__*/_react.default.createElement(JsonCodeEditorCommon, props);
});
exports.JSONCodeEditorCommonMemoized = JSONCodeEditorCommonMemoized;