"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonCodeEditor = void 0;
require("./json_code_editor.scss");
var _react = _interopRequireDefault(require("react"));
var _json_code_editor_common = require("./json_code_editor_common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const JsonCodeEditor = ({
  json,
  width,
  height,
  hasLineNumbers
}) => {
  const jsonValue = JSON.stringify(json, null, 2);
  return /*#__PURE__*/_react.default.createElement(_json_code_editor_common.JsonCodeEditorCommon, {
    jsonValue: jsonValue,
    width: width,
    height: height,
    hasLineNumbers: hasLineNumbers,
    onEditorDidMount: () => void 0,
    hideCopyButton: true
  });
};
exports.JsonCodeEditor = JsonCodeEditor;