"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocTableInfinite = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
require("./index.scss");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _common = require("../../../common");
var _doc_table_wrapper = require("./doc_table_wrapper");
var _skip_bottom_button = require("../../application/main/components/skip_bottom_button");
var _should_load_next_doc_patch = require("./utils/should_load_next_doc_patch");
var _use_discover_services = require("../../hooks/use_discover_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FOOTER_PADDING = {
  padding: 0
};
const DocTableWrapperMemoized = /*#__PURE__*/(0, _react.memo)(_doc_table_wrapper.DocTableWrapper);
const DocTableInfiniteContent = ({
  rows,
  columnLength,
  limit,
  onSkipBottomButtonClick,
  renderHeader,
  renderRows,
  onSetMaxLimit,
  onBackToTop
}) => {
  const {
    uiSettings
  } = (0, _use_discover_services.useDiscoverServices)();
  const sampleSize = (0, _react.useMemo)(() => uiSettings.get(_common.SAMPLE_SIZE_SETTING, 500), [uiSettings]);
  const onSkipBottomButton = (0, _react.useCallback)(() => {
    onSetMaxLimit();
    onSkipBottomButtonClick();
  }, [onSetMaxLimit, onSkipBottomButtonClick]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_skip_bottom_button.SkipBottomButton, {
    onClick: onSkipBottomButton
  }), /*#__PURE__*/_react.default.createElement("table", {
    className: "kbn-table table",
    "data-test-subj": "docTable"
  }, /*#__PURE__*/_react.default.createElement("thead", null, renderHeader()), /*#__PURE__*/_react.default.createElement("tbody", null, renderRows(rows.slice(0, limit))), /*#__PURE__*/_react.default.createElement("tfoot", null, /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement("td", {
    colSpan: (columnLength || 1) + 2,
    style: FOOTER_PADDING
  }, rows.length === sampleSize ? /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnDocTable__footer",
    "data-test-subj": "discoverDocTableFooter",
    tabIndex: -1,
    id: "discoverBottomMarker"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.howToSeeOtherMatchingDocumentsDescription",
    defaultMessage: "These are the first {sampleSize} documents matching\nyour search, refine your search to see others.",
    values: {
      sampleSize
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onBackToTop,
    "data-test-subj": "discoverBackToTop"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.backToTopLinkText",
    defaultMessage: "Back to top."
  }))) : /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: -1,
    id: "discoverBottomMarker"
  }, "\u200B"))))));
};
const DocTableInfinite = props => {
  const tableWrapperRef = (0, _react.useRef)(null);
  const [limit, setLimit] = (0, _react.useState)(50);

  /**
   * depending on which version of Discover is displayed, different elements are scrolling
   * and have therefore to be considered for calculation of infinite scrolling
   */
  (0, _react.useEffect)(() => {
    // After mounting table wrapper should be initialized
    const scrollDiv = tableWrapperRef.current;
    const scrollMobileElem = document.documentElement;
    const scheduleCheck = (0, _lodash.debounce)(() => {
      const isMobileView = document.getElementsByClassName('dscSidebar__mobile').length > 0;
      const usedScrollDiv = isMobileView ? scrollMobileElem : scrollDiv;
      if ((0, _should_load_next_doc_patch.shouldLoadNextDocPatch)(usedScrollDiv)) {
        setLimit(prevLimit => prevLimit + 50);
      }
    }, 50);
    scrollDiv.addEventListener('scroll', scheduleCheck);
    window.addEventListener('scroll', scheduleCheck);
    scheduleCheck();
    return () => {
      scrollDiv.removeEventListener('scroll', scheduleCheck);
      window.removeEventListener('scroll', scheduleCheck);
    };
  }, []);
  const onBackToTop = (0, _react.useCallback)(() => {
    const isMobileView = document.getElementsByClassName('dscSidebar__mobile').length > 0;
    const focusElem = document.querySelector('.dscSkipButton');
    focusElem.focus();

    // Only the desktop one needs to target a specific container
    if (!isMobileView && tableWrapperRef.current) {
      tableWrapperRef.current.scrollTo(0, 0);
    } else if (window) {
      window.scrollTo(0, 0);
    }
  }, []);
  const setMaxLimit = (0, _react.useCallback)(() => setLimit(props.rows.length), [props.rows.length]);
  const renderDocTable = (0, _react.useCallback)(tableProps => /*#__PURE__*/_react.default.createElement(DocTableInfiniteContent, (0, _extends2.default)({}, tableProps, {
    limit: limit,
    onSetMaxLimit: setMaxLimit,
    onBackToTop: onBackToTop
  })), [limit, onBackToTop, setMaxLimit]);
  return /*#__PURE__*/_react.default.createElement(DocTableWrapperMemoized, (0, _extends2.default)({
    ref: tableWrapperRef,
    render: renderDocTable
  }, props));
};
exports.DocTableInfinite = DocTableInfinite;