"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableRowDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_navigation_props = require("../../../hooks/use_navigation_props");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TableRowDetails = ({
  colLength,
  isTimeBased,
  children,
  dataView,
  rowIndex,
  rowId,
  columns,
  filters,
  savedSearchId
}) => {
  const {
    singleDocHref,
    contextViewHref,
    onOpenSingleDoc,
    onOpenContextView
  } = (0, _use_navigation_props.useNavigationProps)({
    dataView,
    rowIndex,
    rowId,
    columns,
    filters,
    savedSearchId
  });
  return /*#__PURE__*/_react.default.createElement("td", {
    colSpan: (colLength || 1) + 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "folderOpen",
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": "docTableRowDetailsTitle"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docTable.tableRow.detailHeading",
    defaultMessage: "Expanded document"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isTimeBased &&
  /*#__PURE__*/
  /* eslint-disable-next-line @elastic/eui/href-or-on-click */
  _react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconSize: "s",
    iconType: "document",
    flush: "left",
    "data-test-subj": "docTableRowAction",
    href: contextViewHref,
    onClick: onOpenContextView
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docTable.tableRow.viewSurroundingDocumentsLinkText",
    defaultMessage: "View surrounding documents"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconSize: "s",
    iconType: "document",
    flush: "left",
    "data-test-subj": "docTableRowAction",
    href: singleDocHref,
    onClick: onOpenSingleDoc
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docTable.tableRow.viewSingleDocumentLinkText",
    defaultMessage: "View single document"
  })))))), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "docViewer"
  }, children));
};
exports.TableRowDetails = TableRowDetails;