"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableHeader = TableHeader;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/field-formats-plugin/common");
var _table_header_column = require("./table_header_column");
var _helpers = require("./helpers");
var _sorting = require("../../../../utils/sorting");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _common2 = require("../../../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function TableHeader({
  columns,
  dataView,
  onChangeSortOrder,
  onMoveColumn,
  onRemoveColumn,
  sortOrder
}) {
  const {
    uiSettings
  } = (0, _use_discover_services.useDiscoverServices)();
  const [defaultSortOrder, hideTimeColumn, isShortDots] = (0, _react.useMemo)(() => [uiSettings.get(_common2.SORT_DEFAULT_ORDER_SETTING, 'desc'), uiSettings.get(_common2.DOC_HIDE_TIME_COLUMN_SETTING, false), uiSettings.get(_common.FORMATS_UI_SETTINGS.SHORT_DOTS_ENABLE)], [uiSettings]);
  const displayedColumns = (0, _helpers.getDisplayedColumns)(columns, dataView, hideTimeColumn, isShortDots);
  return /*#__PURE__*/_react.default.createElement("tr", {
    "data-test-subj": "docTableHeader",
    className: "kbnDocTableHeader"
  }, /*#__PURE__*/_react.default.createElement("th", {
    style: {
      width: '24px'
    }
  }), displayedColumns.map((col, index) => {
    var _dataView$getFieldByN;
    return /*#__PURE__*/_react.default.createElement(_table_header_column.TableHeaderColumn, (0, _extends2.default)({
      key: `${col.name}-${index}`
    }, col, {
      customLabel: (_dataView$getFieldByN = dataView.getFieldByName(col.name)) === null || _dataView$getFieldByN === void 0 ? void 0 : _dataView$getFieldByN.customLabel,
      isTimeColumn: dataView.timeFieldName === col.name,
      sortOrder: sortOrder.length ? sortOrder : (0, _sorting.getDefaultSort)(dataView, defaultSortOrder, hideTimeColumn),
      onMoveColumn: onMoveColumn,
      onRemoveColumn: onRemoveColumn,
      onChangeSortOrder: onChangeSortOrder
    }));
  }));
}