"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRenderCellValueFn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _eui = require("@elastic/eui");
var _discover_grid_context = require("./discover_grid_context");
var _json_code_editor = require("../json_code_editor/json_code_editor");
var _constants = require("./constants");
var _format_value = require("../../utils/format_value");
var _format_hit = require("../../utils/format_hit");
var _use_discover_services = require("../../hooks/use_discover_services");
var _common = require("../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CELL_CLASS = 'dscDiscoverGrid__cellValue';
const getRenderCellValueFn = (dataView, rows, useNewFieldsApi, shouldShowFieldHandler, maxDocFieldsDisplayed, closePopover) => ({
  rowIndex,
  columnId,
  isDetails,
  setCellProps
}) => {
  const {
    uiSettings,
    fieldFormats
  } = (0, _use_discover_services.useDiscoverServices)();
  const maxEntries = (0, _react.useMemo)(() => uiSettings.get(_common.MAX_DOC_FIELDS_DISPLAYED), [uiSettings]);
  const row = rows ? rows[rowIndex] : undefined;
  const field = dataView.fields.getByName(columnId);
  const ctx = (0, _react.useContext)(_discover_grid_context.DiscoverGridContext);
  (0, _react.useEffect)(() => {
    if (row !== null && row !== void 0 && row.isAnchor) {
      setCellProps({
        className: 'dscDocsGrid__cell--highlight'
      });
    } else if (ctx.expanded && row && ctx.expanded.id === row.id) {
      setCellProps({
        style: {
          backgroundColor: ctx.isDarkMode ? _uiTheme.euiDarkVars.euiColorHighlight : _uiTheme.euiLightVars.euiColorHighlight
        }
      });
    } else {
      setCellProps({
        style: undefined
      });
    }
  }, [ctx, row, setCellProps]);
  if (typeof row === 'undefined') {
    return /*#__PURE__*/_react.default.createElement("span", {
      className: CELL_CLASS
    }, "-");
  }

  /**
   * when using the fields api this code is used to show top level objects
   * this is used for legacy stuff like displaying products of our ecommerce dataset
   */
  const useTopLevelObjectColumns = Boolean(useNewFieldsApi && !field && (row === null || row === void 0 ? void 0 : row.raw.fields) && !row.raw.fields[columnId]);
  if (isDetails) {
    return renderPopoverContent({
      row,
      field,
      columnId,
      dataView,
      useTopLevelObjectColumns,
      fieldFormats,
      closePopover
    });
  }
  if ((field === null || field === void 0 ? void 0 : field.type) === '_source' || useTopLevelObjectColumns) {
    const pairs = useTopLevelObjectColumns ? getTopLevelObjectPairs(row.raw, columnId, dataView, shouldShowFieldHandler).slice(0, maxDocFieldsDisplayed) : (0, _format_hit.formatHit)(row, dataView, shouldShowFieldHandler, maxEntries, fieldFormats);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      type: "inline",
      compressed: true,
      className: (0, _classnames.default)('dscDiscoverGrid__descriptionList', CELL_CLASS)
    }, pairs.map(([key, value]) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: key
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, key), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "dscDiscoverGrid__descriptionListDescription",
      dangerouslySetInnerHTML: {
        __html: value
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    className: CELL_CLASS
    // formatFieldValue guarantees sanitized values
    // eslint-disable-next-line react/no-danger
    ,
    dangerouslySetInnerHTML: {
      __html: (0, _format_value.formatFieldValue)(row.flattened[columnId], row.raw, fieldFormats, dataView, field)
    }
  });
};

/**
 * Helper function to show top level objects
 * this is used for legacy stuff like displaying products of our ecommerce dataset
 */
exports.getRenderCellValueFn = getRenderCellValueFn;
function getInnerColumns(fields, columnId) {
  return Object.fromEntries(Object.entries(fields).filter(([key]) => {
    return key.indexOf(`${columnId}.`) === 0;
  }));
}
function getJSON(columnId, row, useTopLevelObjectColumns) {
  const json = useTopLevelObjectColumns ? getInnerColumns(row.raw.fields, columnId) : row.raw;
  return json;
}

/**
 * Helper function for the cell popover
 */
function renderPopoverContent({
  row,
  field,
  columnId,
  dataView,
  useTopLevelObjectColumns,
  fieldFormats,
  closePopover
}) {
  const closeButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('discover.grid.closePopover', {
      defaultMessage: `Close popover`
    }),
    "data-test-subj": "docTableClosePopover",
    iconSize: "s",
    iconType: "cross",
    size: "xs",
    onClick: closePopover
  });
  if (useTopLevelObjectColumns || (field === null || field === void 0 ? void 0 : field.type) === '_source') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      direction: "column",
      justifyContent: "flexEnd",
      className: "dscDiscoverGrid__cellPopover"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "none",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, closeButton))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_json_code_editor.JsonCodeEditor, {
      json: getJSON(columnId, row, useTopLevelObjectColumns),
      width: _constants.defaultMonacoEditorWidth,
      height: 200
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "row",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", {
    className: "dscDiscoverGrid__cellPopoverValue eui-textBreakWord"
    // formatFieldValue guarantees sanitized values
    // eslint-disable-next-line react/no-danger
    ,
    dangerouslySetInnerHTML: {
      __html: (0, _format_value.formatFieldValue)(row.flattened[columnId], row.raw, fieldFormats, dataView, field)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, closeButton));
}
/**
 * Helper function to show top level objects
 * this is used for legacy stuff like displaying products of our ecommerce dataset
 */
function getTopLevelObjectPairs(row, columnId, dataView, shouldShowFieldHandler) {
  var _ref;
  const innerColumns = getInnerColumns(row.fields, columnId);
  // Put the most important fields first
  const highlights = (_ref = row.highlight) !== null && _ref !== void 0 ? _ref : {};
  const highlightPairs = [];
  const sourcePairs = [];
  Object.entries(innerColumns).forEach(([key, values]) => {
    var _dataView$fields$getB;
    const subField = dataView.getFieldByName(key);
    const displayKey = dataView.fields.getByName ? (_dataView$fields$getB = dataView.fields.getByName(key)) === null || _dataView$fields$getB === void 0 ? void 0 : _dataView$fields$getB.displayName : undefined;
    const formatter = subField ? dataView.getFormatterForField(subField) : {
      convert: (v, ...rest) => String(v)
    };
    const formatted = values.map(val => formatter.convert(val, 'html', {
      field: subField,
      hit: row
    })).join(', ');
    const pairs = highlights[key] ? highlightPairs : sourcePairs;
    if (displayKey) {
      if (shouldShowFieldHandler(displayKey)) {
        pairs.push([displayKey, formatted]);
      }
    } else {
      pairs.push([key, formatted]);
    }
  });
  return [...highlightPairs, ...sourcePairs];
}