"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverGridFlyout = DiscoverGridFlyout;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _doc_viewer = require("../../services/doc_views/components/doc_viewer/doc_viewer");
var _use_navigation_props = require("../../hooks/use_navigation_props");
var _use_discover_services = require("../../hooks/use_discover_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getIndexByDocId(hits, id) {
  return hits.findIndex(h => {
    return h.id === id;
  });
}
/**
 * Flyout displaying an expanded Elasticsearch document
 */
function DiscoverGridFlyout({
  hit,
  hits,
  dataView,
  columns,
  savedSearchId,
  filters,
  onFilter,
  onClose,
  onRemoveColumn,
  onAddColumn,
  setExpandedDoc
}) {
  const services = (0, _use_discover_services.useDiscoverServices)();
  // Get actual hit with updated highlighted searches
  const actualHit = (0, _react.useMemo)(() => (hits === null || hits === void 0 ? void 0 : hits.find(({
    id
  }) => id === (hit === null || hit === void 0 ? void 0 : hit.id))) || hit, [hit, hits]);
  const pageCount = (0, _react.useMemo)(() => hits ? hits.length : 0, [hits]);
  const activePage = (0, _react.useMemo)(() => {
    const id = hit.id;
    if (!hits || pageCount <= 1) {
      return -1;
    }
    return getIndexByDocId(hits, id);
  }, [hits, hit, pageCount]);
  const setPage = (0, _react.useCallback)(index => {
    if (hits && hits[index]) {
      setExpandedDoc(hits[index]);
    }
  }, [hits, setExpandedDoc]);
  const onKeyDown = (0, _react.useCallback)(ev => {
    if (ev.key === _eui.keys.ARROW_LEFT || ev.key === _eui.keys.ARROW_RIGHT) {
      ev.preventDefault();
      ev.stopPropagation();
      setPage(activePage + (ev.key === _eui.keys.ARROW_RIGHT ? 1 : -1));
    }
  }, [activePage, setPage]);
  const {
    singleDocHref,
    contextViewHref,
    onOpenSingleDoc,
    onOpenContextView
  } = (0, _use_navigation_props.useNavigationProps)({
    dataView,
    rowIndex: hit.raw._index,
    rowId: hit.raw._id,
    columns,
    filters,
    savedSearchId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "m",
    "data-test-subj": "docTableDetailsFlyout",
    onKeyDown: onKeyDown,
    ownFocus: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    className: "dscTable__flyoutHeader",
    "data-test-subj": "docTableRowDetailsTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('discover.grid.tableRow.detailHeading', {
    defaultMessage: 'Expanded document'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['xs', 's', 'm']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('discover.grid.tableRow.viewText', {
    defaultMessage: 'View:'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconSize: "s",
    iconType: "document",
    flush: "left",
    "data-test-subj": "docTableRowAction",
    href: singleDocHref,
    onClick: onOpenSingleDoc
  }, _i18n.i18n.translate('discover.grid.tableRow.viewSingleDocumentLinkTextSimple', {
    defaultMessage: 'Single document'
  }))), dataView.isTimeBased() && dataView.id && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconSize: "s",
    iconType: "documents",
    flush: "left",
    onClick: onOpenContextView,
    href: contextViewHref,
    "data-test-subj": "docTableRowAction"
  }, _i18n.i18n.translate('discover.grid.tableRow.viewSurroundingDocumentsLinkTextSimple', {
    defaultMessage: 'Surrounding documents'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('discover.grid.tableRow.viewSurroundingDocumentsHover', {
      defaultMessage: 'Inspect documents that occurred before and after this document. Only pinned filters remain active in the Surrounding documents view.'
    }),
    type: "questionInCircle",
    color: "subdued",
    position: "right",
    iconProps: {
      className: 'eui-alignTop'
    }
  }))), activePage !== -1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `dscDocNavigationPage-${activePage}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('discover.grid.flyout.documentNavigation', {
      defaultMessage: 'Document navigation'
    }),
    pageCount: pageCount,
    activePage: activePage,
    onPageClick: setPage,
    className: "dscTable__flyoutDocumentNavigation",
    compressed: true,
    "data-test-subj": "dscDocNavigation"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_doc_viewer.DocViewer, {
    hit: actualHit,
    columns: columns,
    dataView: dataView,
    filter: onFilter,
    onRemoveColumn: columnName => {
      onRemoveColumn(columnName);
      services.toastNotifications.addSuccess(_i18n.i18n.translate('discover.grid.flyout.toastColumnRemoved', {
        defaultMessage: `Column '{columnName}' was removed`,
        values: {
          columnName
        }
      }));
    },
    onAddColumn: columnName => {
      onAddColumn(columnName);
      services.toastNotifications.addSuccess(_i18n.i18n.translate('discover.grid.flyout.toastColumnAdded', {
        defaultMessage: `Column '{columnName}' was added`,
        values: {
          columnName
        }
      }));
    }
  }))));
}