"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverGridDocumentToolbarBtn = DiscoverGridDocumentToolbarBtn;
exports.SelectButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _discover_grid_context = require("./discover_grid_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SelectButton = ({
  rowIndex,
  setCellProps
}) => {
  const {
    selectedDocs,
    expanded,
    rows,
    isDarkMode,
    setSelectedDocs
  } = (0, _react.useContext)(_discover_grid_context.DiscoverGridContext);
  const doc = (0, _react.useMemo)(() => rows[rowIndex], [rows, rowIndex]);
  const checked = (0, _react.useMemo)(() => selectedDocs.includes(doc.id), [selectedDocs, doc.id]);
  const toggleDocumentSelectionLabel = _i18n.i18n.translate('discover.grid.selectDoc', {
    defaultMessage: `Select document '{rowNumber}'`,
    values: {
      rowNumber: rowIndex + 1
    }
  });
  (0, _react.useEffect)(() => {
    if (expanded && doc && expanded.id === doc.id) {
      setCellProps({
        style: {
          backgroundColor: isDarkMode ? _uiTheme.euiDarkVars.euiColorHighlight : _uiTheme.euiLightVars.euiColorHighlight
        }
      });
    } else {
      setCellProps({
        style: undefined
      });
    }
  }, [expanded, doc, setCellProps, isDarkMode]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: doc.id,
    "aria-label": toggleDocumentSelectionLabel,
    checked: checked,
    "data-test-subj": `dscGridSelectDoc-${doc.id}`,
    onChange: () => {
      if (checked) {
        const newSelection = selectedDocs.filter(docId => docId !== doc.id);
        setSelectedDocs(newSelection);
      } else {
        setSelectedDocs([...selectedDocs, doc.id]);
      }
    }
  });
};
exports.SelectButton = SelectButton;
function DiscoverGridDocumentToolbarBtn({
  isFilterActive,
  rows,
  selectedDocs,
  setIsFilterActive,
  setSelectedDocs
}) {
  const [isSelectionPopoverOpen, setIsSelectionPopoverOpen] = (0, _react.useState)(false);
  const getMenuItems = (0, _react.useCallback)(() => {
    return [isFilterActive ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "dscGridShowAllDocuments",
      key: "showAllDocuments",
      icon: "eye",
      onClick: () => {
        setIsSelectionPopoverOpen(false);
        setIsFilterActive(false);
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.showAllDocuments",
      defaultMessage: "Show all documents"
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "dscGridShowSelectedDocuments",
      key: "showSelectedDocuments",
      icon: "eye",
      onClick: () => {
        setIsSelectionPopoverOpen(false);
        setIsFilterActive(true);
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.showSelectedDocumentsOnly",
      defaultMessage: "Show selected documents only"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      key: "copyJsonWrapper",
      "data-test-subj": "dscGridCopySelectedDocumentsJSON",
      textToCopy: rows ? JSON.stringify(rows.filter(row => selectedDocs.includes(row.id)).map(row => row.raw)) : ''
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "copyJSON",
      icon: "copyClipboard",
      onClick: copy
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.copyToClipboardJSON",
      defaultMessage: "Copy documents to clipboard (JSON)"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "dscGridClearSelectedDocuments",
      key: "clearSelection",
      icon: "cross",
      onClick: () => {
        setIsSelectionPopoverOpen(false);
        setSelectedDocs([]);
        setIsFilterActive(false);
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.clearSelection",
      defaultMessage: "Clear selection"
    }))];
  }, [isFilterActive, rows, selectedDocs, setIsFilterActive, setIsSelectionPopoverOpen, setSelectedDocs]);
  const toggleSelectionToolbar = (0, _react.useCallback)(() => setIsSelectionPopoverOpen(prevIsOpen => !prevIsOpen), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    closePopover: () => setIsSelectionPopoverOpen(false),
    isOpen: isSelectionPopoverOpen,
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      color: "text",
      iconType: "documents",
      onClick: toggleSelectionToolbar,
      "data-selected-documents": selectedDocs.length,
      "data-test-subj": "dscGridSelectionBtn",
      isSelected: isFilterActive,
      className: (0, _classnames.default)({
        // eslint-disable-next-line @typescript-eslint/naming-convention
        euiDataGrid__controlBtn: true,
        'euiDataGrid__controlBtn--active': isFilterActive
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.selectedDocumentsNumber",
      defaultMessage: "{nr} documents selected",
      values: {
        nr: selectedDocs.length
      }
    }))
  }, isSelectionPopoverOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: getMenuItems()
  }));
}