"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEuiGridColumns = getEuiGridColumns;
exports.getLeadControlColumns = getLeadControlColumns;
exports.getVisibleColumns = getVisibleColumns;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _discover_grid_expand_button = require("./discover_grid_expand_button");
var _discover_grid_cell_actions = require("./discover_grid_cell_actions");
var _discover_grid_schema = require("./discover_grid_schema");
var _discover_grid_document_selection = require("./discover_grid_document_selection");
var _constants = require("./constants");
var _build_copy_column_button = require("./build_copy_column_button");
var _build_edit_field_button = require("./build_edit_field_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const openDetails = {
  id: 'openDetails',
  width: 24,
  headerCellRender: () => /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('discover.controlColumnHeader', {
    defaultMessage: 'Control column'
  }))),
  rowCellRender: _discover_grid_expand_button.ExpandButton
};
const select = {
  id: 'select',
  width: 24,
  rowCellRender: _discover_grid_document_selection.SelectButton,
  headerCellRender: () => /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('discover.selectColumnHeader', {
    defaultMessage: 'Select column'
  })))
};
function getLeadControlColumns(canSetExpandedDoc) {
  if (!canSetExpandedDoc) {
    return [select];
  }
  return [openDetails, select];
}
function buildEuiGridColumn({
  columnName,
  columnWidth = 0,
  dataView,
  defaultColumns,
  isSortEnabled,
  toastNotifications,
  hasEditDataViewPermission,
  valueToStringConverter,
  rowsCount,
  onFilter,
  editField
}) {
  const dataViewField = dataView.getFieldByName(columnName);
  const editFieldButton = editField && dataViewField && (0, _build_edit_field_button.buildEditFieldButton)({
    hasEditDataViewPermission,
    dataView,
    field: dataViewField,
    editField
  });
  const columnDisplayName = columnName === '_source' ? _i18n.i18n.translate('discover.grid.documentHeader', {
    defaultMessage: 'Document'
  }) : (dataViewField === null || dataViewField === void 0 ? void 0 : dataViewField.displayName) || columnName;
  const column = {
    id: columnName,
    schema: (0, _discover_grid_schema.getSchemaByKbnType)(dataViewField === null || dataViewField === void 0 ? void 0 : dataViewField.type),
    isSortable: isSortEnabled && (dataViewField === null || dataViewField === void 0 ? void 0 : dataViewField.sortable) === true,
    displayAsText: columnDisplayName,
    actions: {
      showHide: defaultColumns || columnName === dataView.timeFieldName ? false : {
        label: _i18n.i18n.translate('discover.removeColumnLabel', {
          defaultMessage: 'Remove column'
        }),
        iconType: 'cross'
      },
      showMoveLeft: !defaultColumns,
      showMoveRight: !defaultColumns,
      additional: [...(columnName === '__source' ? [] : [(0, _build_copy_column_button.buildCopyColumnNameButton)({
        columnDisplayName,
        toastNotifications
      })]), (0, _build_copy_column_button.buildCopyColumnValuesButton)({
        columnId: columnName,
        columnDisplayName,
        toastNotifications,
        rowsCount,
        valueToStringConverter
      }), ...(editFieldButton ? [editFieldButton] : [])]
    },
    cellActions: dataViewField ? (0, _discover_grid_cell_actions.buildCellActions)(dataViewField, onFilter) : []
  };
  if (column.id === dataView.timeFieldName) {
    var _dataViewField$custom;
    const timeFieldName = (_dataViewField$custom = dataViewField === null || dataViewField === void 0 ? void 0 : dataViewField.customLabel) !== null && _dataViewField$custom !== void 0 ? _dataViewField$custom : dataView.timeFieldName;
    const primaryTimeAriaLabel = _i18n.i18n.translate('discover.docTable.tableHeader.timeFieldIconTooltipAriaLabel', {
      defaultMessage: '{timeFieldName} - this field represents the time that events occurred.',
      values: {
        timeFieldName
      }
    });
    const primaryTimeTooltip = _i18n.i18n.translate('discover.docTable.tableHeader.timeFieldIconTooltip', {
      defaultMessage: 'This field represents the time that events occurred.'
    });
    column.display = /*#__PURE__*/_react.default.createElement("div", {
      "aria-label": primaryTimeAriaLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: primaryTimeTooltip
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, timeFieldName, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "clock"
    }))));
    column.initialWidth = _constants.defaultTimeColumnWidth;
  }
  if (columnWidth > 0) {
    column.initialWidth = Number(columnWidth);
  }
  return column;
}
function getEuiGridColumns({
  columns,
  rowsCount,
  settings,
  dataView,
  showTimeCol,
  defaultColumns,
  isSortEnabled,
  services,
  hasEditDataViewPermission,
  valueToStringConverter,
  onFilter,
  editField
}) {
  const timeFieldName = dataView.timeFieldName;
  const getColWidth = column => {
    var _settings$columns$col, _settings$columns, _settings$columns$col2;
    return (_settings$columns$col = settings === null || settings === void 0 ? void 0 : (_settings$columns = settings.columns) === null || _settings$columns === void 0 ? void 0 : (_settings$columns$col2 = _settings$columns[column]) === null || _settings$columns$col2 === void 0 ? void 0 : _settings$columns$col2.width) !== null && _settings$columns$col !== void 0 ? _settings$columns$col : 0;
  };
  let visibleColumns = columns;
  if (showTimeCol && dataView.timeFieldName && !columns.find(col => col === timeFieldName)) {
    visibleColumns = [dataView.timeFieldName, ...columns];
  }
  return visibleColumns.map(column => buildEuiGridColumn({
    columnName: column,
    columnWidth: getColWidth(column),
    dataView,
    defaultColumns,
    isSortEnabled,
    toastNotifications: services.toastNotifications,
    hasEditDataViewPermission,
    valueToStringConverter,
    rowsCount,
    onFilter,
    editField
  }));
}
function getVisibleColumns(columns, dataView, showTimeCol) {
  const timeFieldName = dataView.timeFieldName;
  if (showTimeCol && !columns.find(col => col === timeFieldName)) {
    return [timeFieldName, ...columns];
  }
  return columns;
}