"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterOutBtn = exports.FilterInBtn = exports.CopyBtn = void 0;
exports.buildCellActions = buildCellActions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _discover_grid_context = require("./discover_grid_context");
var _use_discover_services = require("../../hooks/use_discover_services");
var _copy_value_to_clipboard = require("../../utils/copy_value_to_clipboard");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function onFilterCell(context, rowIndex, columnId, mode) {
  const row = context.rows[rowIndex];
  const value = row.flattened[columnId];
  const field = context.dataView.fields.getByName(columnId);
  if (field && context.onFilter) {
    context.onFilter(field, value, mode);
  }
}
const FilterInBtn = ({
  Component,
  rowIndex,
  columnId
}) => {
  const context = (0, _react.useContext)(_discover_grid_context.DiscoverGridContext);
  const buttonTitle = _i18n.i18n.translate('discover.grid.filterForAria', {
    defaultMessage: 'Filter for this {value}',
    values: {
      value: columnId
    }
  });
  return /*#__PURE__*/_react.default.createElement(Component, {
    onClick: () => {
      onFilterCell(context, rowIndex, columnId, '+');
    },
    iconType: "plusInCircle",
    "aria-label": buttonTitle,
    title: buttonTitle,
    "data-test-subj": "filterForButton"
  }, _i18n.i18n.translate('discover.grid.filterFor', {
    defaultMessage: 'Filter for'
  }));
};
exports.FilterInBtn = FilterInBtn;
const FilterOutBtn = ({
  Component,
  rowIndex,
  columnId
}) => {
  const context = (0, _react.useContext)(_discover_grid_context.DiscoverGridContext);
  const buttonTitle = _i18n.i18n.translate('discover.grid.filterOutAria', {
    defaultMessage: 'Filter out this {value}',
    values: {
      value: columnId
    }
  });
  return /*#__PURE__*/_react.default.createElement(Component, {
    onClick: () => {
      onFilterCell(context, rowIndex, columnId, '-');
    },
    iconType: "minusInCircle",
    "aria-label": buttonTitle,
    title: buttonTitle,
    "data-test-subj": "filterOutButton"
  }, _i18n.i18n.translate('discover.grid.filterOut', {
    defaultMessage: 'Filter out'
  }));
};
exports.FilterOutBtn = FilterOutBtn;
const CopyBtn = ({
  Component,
  rowIndex,
  columnId
}) => {
  const {
    valueToStringConverter
  } = (0, _react.useContext)(_discover_grid_context.DiscoverGridContext);
  const {
    toastNotifications
  } = (0, _use_discover_services.useDiscoverServices)();
  const buttonTitle = _i18n.i18n.translate('discover.grid.copyClipboardButtonTitle', {
    defaultMessage: 'Copy value of {column}',
    values: {
      column: columnId
    }
  });
  return /*#__PURE__*/_react.default.createElement(Component, {
    onClick: () => {
      (0, _copy_value_to_clipboard.copyValueToClipboard)({
        rowIndex,
        columnId,
        toastNotifications,
        valueToStringConverter
      });
    },
    iconType: "copyClipboard",
    "aria-label": buttonTitle,
    title: buttonTitle,
    "data-test-subj": "copyClipboardButton"
  }, _i18n.i18n.translate('discover.grid.copyCellValueButton', {
    defaultMessage: 'Copy value'
  }));
};
exports.CopyBtn = CopyBtn;
function buildCellActions(field, onFilter) {
  return [...(onFilter && field.filterable ? [FilterInBtn, FilterOutBtn] : []), CopyBtn];
}