"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCallout = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _public = require("@kbn/data-plugin/public");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _use_discover_services = require("../../hooks/use_discover_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ErrorCallout = ({
  title,
  error,
  inline,
  'data-test-subj': dataTestSubj
}) => {
  var _overrideDisplay$body;
  const {
    core
  } = (0, _use_discover_services.useDiscoverServices)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const showErrorMessage = _i18n.i18n.translate('discover.errorCalloutShowErrorMessage', {
    defaultMessage: 'Show details'
  });
  const overrideDisplay = (0, _public.getSearchErrorOverrideDisplay)({
    error,
    application: core.application
  });
  const [overrideModalOpen, setOverrideModalOpen] = (0, _react2.useState)(false);
  const showError = overrideDisplay !== null && overrideDisplay !== void 0 && overrideDisplay.body ? () => setOverrideModalOpen(true) : () => core.notifications.showErrorDialog({
    title,
    error
  });
  let formattedTitle = (overrideDisplay === null || overrideDisplay === void 0 ? void 0 : overrideDisplay.title) || title;
  if (inline) {
    const formattedTitleMessage = overrideDisplay ? formattedTitle : _i18n.i18n.translate('discover.errorCalloutFormattedTitle', {
      defaultMessage: '{title}: {errorMessage}',
      values: {
        title,
        errorMessage: error.message
      }
    });
    formattedTitle = /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("span", {
      className: "eui-textTruncate",
      "data-test-subj": "discoverErrorCalloutMessage"
    }, formattedTitleMessage), /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
      onClick: showError,
      css: (0, _react.css)`
            white-space: nowrap;
            margin-inline-start: ${euiTheme.size.s};
          `
    }, showErrorMessage));
  }
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, inline ? /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    title: formattedTitle,
    color: "danger",
    iconType: "error",
    size: "s",
    css: (0, _react.css)`
            .euiTitle {
              display: flex;
              align-items: center;
            }
          `,
    "data-test-subj": dataTestSubj
  }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    color: "danger",
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: "error",
      color: "danger",
      size: "l"
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("h2", {
      "data-test-subj": "discoverErrorCalloutTitle"
    }, formattedTitle))),
    body: (_overrideDisplay$body = overrideDisplay === null || overrideDisplay === void 0 ? void 0 : overrideDisplay.body) !== null && _overrideDisplay$body !== void 0 ? _overrideDisplay$body : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("p", {
      css: (0, _react.css)`
                    white-space: break-spaces;
                    font-family: ${euiTheme.font.familyCode};
                  `,
      "data-test-subj": "discoverErrorCalloutMessage"
    }, error.message), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      onClick: showError
    }, showErrorMessage)),
    css: (0, _react.css)`
            text-align: left;
          `,
    "data-test-subj": dataTestSubj
  }), overrideDisplay && overrideModalOpen && /*#__PURE__*/_react2.default.createElement(_eui.EuiModal, {
    onClose: () => setOverrideModalOpen(false)
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "discoverErrorCalloutOverrideModalTitle"
  }, overrideDisplay.title)), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    "data-test-subj": "discoverErrorCalloutOverrideModalBody"
  }, overrideDisplay.body))));
};
exports.ErrorCallout = ErrorCallout;