"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildServices = void 0;
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
var _kibana_services = require("./kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const buildServices = (0, _lodash.memoize)(function (core, plugins, context, locator, contextLocator, singleDocLocator) {
  var _plugins$savedObjects;
  const {
    usageCollection
  } = plugins;
  const storage = new _public.Storage(localStorage);
  return {
    application: core.application,
    addBasePath: core.http.basePath.prepend,
    capabilities: core.application.capabilities,
    chrome: core.chrome,
    core,
    data: plugins.data,
    docLinks: core.docLinks,
    embeddable: plugins.embeddable,
    theme: plugins.charts.theme,
    fieldFormats: plugins.fieldFormats,
    filterManager: plugins.data.query.filterManager,
    history: _kibana_services.getHistory,
    dataViews: plugins.data.dataViews,
    inspector: plugins.inspector,
    metadata: {
      branch: context.env.packageInfo.branch
    },
    navigation: plugins.navigation,
    share: plugins.share,
    urlForwarding: plugins.urlForwarding,
    timefilter: plugins.data.query.timefilter.timefilter,
    toastNotifications: core.notifications.toasts,
    notifications: core.notifications,
    uiSettings: core.uiSettings,
    storage,
    trackUiMetric: usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter.bind(usageCollection, 'discover'),
    dataViewFieldEditor: plugins.dataViewFieldEditor,
    http: core.http,
    spaces: plugins.spaces,
    dataViewEditor: plugins.dataViewEditor,
    triggersActionsUi: plugins.triggersActionsUi,
    locator,
    contextLocator,
    singleDocLocator,
    expressions: plugins.expressions,
    charts: plugins.charts,
    savedObjectsTagging: (_plugins$savedObjects = plugins.savedObjectsTaggingOss) === null || _plugins$savedObjects === void 0 ? void 0 : _plugins$savedObjects.getTaggingApi(),
    savedObjectsManagement: plugins.savedObjectsManagement,
    unifiedSearch: plugins.unifiedSearch,
    lens: plugins.lens
  };
});
exports.buildServices = buildServices;