"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertUtils = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/data-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LEGACY_BASE_ALERT_API_PATH = '/api/alerts';
const buildTimeRangeFilter = (dataView, fetchedAlert, timeFieldName) => {
  const filter = (0, _common.getTime)(dataView, {
    from: `now-${fetchedAlert.params.timeWindowSize}${fetchedAlert.params.timeWindowUnit}`,
    to: 'now'
  });
  return {
    from: filter === null || filter === void 0 ? void 0 : filter.query.range[timeFieldName].gte,
    to: filter === null || filter === void 0 ? void 0 : filter.query.range[timeFieldName].lte
  };
};
const getAlertUtils = (openActualAlert, queryParams, toastNotifications, core, data) => {
  const showDataViewFetchError = alertId => {
    const errorTitle = _i18n.i18n.translate('discover.viewAlert.dataViewErrorTitle', {
      defaultMessage: 'Error fetching data view'
    });
    toastNotifications.addDanger({
      title: errorTitle,
      text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.MarkdownSimple, null, new Error(`Data view failure of the alert rule with id ${alertId}.`).message))
    });
  };
  const fetchAlert = async id => {
    try {
      return await core.http.get(`${LEGACY_BASE_ALERT_API_PATH}/alert/${id}`);
    } catch (error) {
      const errorTitle = _i18n.i18n.translate('discover.viewAlert.alertRuleFetchErrorTitle', {
        defaultMessage: 'Error fetching alert rule'
      });
      toastNotifications.addDanger({
        title: errorTitle,
        text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.MarkdownSimple, null, error.message))
      });
      throw new Error(errorTitle);
    }
  };
  const fetchSearchSource = async fetchedAlert => {
    try {
      return {
        alert: fetchedAlert,
        searchSource: await data.search.searchSource.create(fetchedAlert.params.searchConfiguration)
      };
    } catch (error) {
      const errorTitle = _i18n.i18n.translate('discover.viewAlert.searchSourceErrorTitle', {
        defaultMessage: 'Error fetching search source'
      });
      toastNotifications.addDanger({
        title: errorTitle,
        text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.MarkdownSimple, null, error.message))
      });
      throw new Error(errorTitle);
    }
  };
  const buildLocatorParams = ({
    alert,
    searchSource
  }) => {
    const dataView = searchSource.getField('index');
    const timeFieldName = dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName;
    // data view fetch error
    if (!dataView || !timeFieldName) {
      showDataViewFetchError(alert.id);
      throw new Error('Data view fetch error');
    }
    const timeRange = openActualAlert ? {
      from: queryParams.from,
      to: queryParams.to
    } : buildTimeRangeFilter(dataView, alert, timeFieldName);
    return {
      query: searchSource.getField('query') || data.query.queryString.getDefaultQuery(),
      dataViewSpec: dataView.toSpec(false),
      timeRange,
      filters: searchSource.getField('filter')
    };
  };
  return {
    fetchAlert,
    fetchSearchSource,
    buildLocatorParams
  };
};
exports.getAlertUtils = getAlertUtils;