"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.persistSavedSearch = persistSavedSearch;
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/saved-search-plugin/public");
var _update_search_source = require("./update_search_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Helper function to update and persist the given savedSearch
 */
async function persistSavedSearch(savedSearch, {
  dataView,
  onError,
  onSuccess,
  services,
  saveOptions,
  state
}) {
  (0, _update_search_source.updateSearchSource)(savedSearch.searchSource, true, {
    dataView,
    services,
    sort: state.sort,
    useNewFieldsApi: false
  });
  savedSearch.columns = state.columns || [];
  savedSearch.sort = state.sort || [];
  if (state.grid) {
    savedSearch.grid = state.grid;
  }
  if (typeof state.hideChart !== 'undefined') {
    savedSearch.hideChart = state.hideChart;
  }
  if (typeof state.rowHeight !== 'undefined') {
    savedSearch.rowHeight = state.rowHeight;
  }
  if (state.viewMode) {
    savedSearch.viewMode = state.viewMode;
  }
  if (typeof state.breakdownField !== 'undefined') {
    savedSearch.breakdownField = state.breakdownField;
  } else if (savedSearch.breakdownField) {
    savedSearch.breakdownField = '';
  }
  if (state.hideAggregatedPreview) {
    savedSearch.hideAggregatedPreview = state.hideAggregatedPreview;
  }

  // add a flag here to identify text based language queries
  // these should be filtered out from the visualize editor
  const isTextBasedQuery = state.query && (0, _esQuery.isOfAggregateQueryType)(state.query);
  if (savedSearch.isTextBasedQuery || isTextBasedQuery) {
    savedSearch.isTextBasedQuery = isTextBasedQuery;
  }
  savedSearch.usesAdHocDataView = !dataView.isPersisted();
  const {
    from,
    to
  } = services.timefilter.getTime();
  const refreshInterval = services.timefilter.getRefreshInterval();
  savedSearch.timeRange = savedSearch.timeRestore || savedSearch.timeRange ? {
    from,
    to
  } : undefined;
  savedSearch.refreshInterval = savedSearch.timeRestore || savedSearch.refreshInterval ? {
    value: refreshInterval.value,
    pause: refreshInterval.pause
  } : undefined;
  try {
    const id = await (0, _public.saveSavedSearch)(savedSearch, saveOptions, services.core.savedObjects.client, services.savedObjectsTagging);
    if (id) {
      onSuccess(id);
    }
    return {
      id
    };
  } catch (saveError) {
    onError(saveError, savedSearch);
    return {
      error: saveError
    };
  }
}