"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSql = fetchSql;
var _operators = require("rxjs/operators");
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function fetchSql(query, dataView, data, expressions, inspectorAdapters, filters, inputQuery) {
  const timeRange = data.query.timefilter.timefilter.getTime();
  return (0, _common.textBasedQueryStateToAstWithValidation)({
    filters,
    query,
    time: timeRange,
    dataView,
    inputQuery
  }).then(ast => {
    if (ast) {
      const execution = expressions.run(ast, null, {
        inspectorAdapters
      });
      let finalData = [];
      let textBasedQueryColumns;
      let error;
      execution.pipe((0, _operators.pluck)('result')).subscribe(resp => {
        const response = resp;
        if (response.type === 'error') {
          error = response.error.message;
        } else {
          var _table$rows, _table$columns;
          const table = response;
          const rows = (_table$rows = table === null || table === void 0 ? void 0 : table.rows) !== null && _table$rows !== void 0 ? _table$rows : [];
          textBasedQueryColumns = (_table$columns = table === null || table === void 0 ? void 0 : table.columns) !== null && _table$columns !== void 0 ? _table$columns : undefined;
          finalData = rows.map((row, idx) => ({
            id: String(idx),
            raw: row,
            flattened: row
          }));
        }
      });
      return (0, _rxjs.lastValueFrom)(execution).then(() => {
        if (error) {
          throw new Error(error);
        } else {
          return {
            records: finalData || [],
            textBasedQueryColumns
          };
        }
      });
    }
    return {
      records: [],
      textBasedQueryColumns: []
    };
  }).catch(err => {
    throw new Error(err.message);
  });
}