"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanupUrlState = cleanupUrlState;
var _esQuery = require("@kbn/es-query");
var _migrate_legacy_query = require("../../../utils/migrate_legacy_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Takes care of the given url state, migrates legacy props and cleans up empty props
 * @param appStateFromUrl
 */
function cleanupUrlState(appStateFromUrl) {
  var _appStateFromUrl$sort;
  if (appStateFromUrl && appStateFromUrl.query && !(0, _esQuery.isOfAggregateQueryType)(appStateFromUrl.query) && !appStateFromUrl.query.language) {
    appStateFromUrl.query = (0, _migrate_legacy_query.migrateLegacyQuery)(appStateFromUrl.query);
  }
  if (typeof (appStateFromUrl === null || appStateFromUrl === void 0 ? void 0 : (_appStateFromUrl$sort = appStateFromUrl.sort) === null || _appStateFromUrl$sort === void 0 ? void 0 : _appStateFromUrl$sort[0]) === 'string') {
    var _appStateFromUrl$sort2;
    if ((appStateFromUrl === null || appStateFromUrl === void 0 ? void 0 : (_appStateFromUrl$sort2 = appStateFromUrl.sort) === null || _appStateFromUrl$sort2 === void 0 ? void 0 : _appStateFromUrl$sort2[1]) === 'asc' || appStateFromUrl.sort[1] === 'desc') {
      // handling sort props like this[fieldName,direction]
      appStateFromUrl.sort = [[appStateFromUrl.sort[0], appStateFromUrl.sort[1]]];
    } else {
      delete appStateFromUrl.sort;
    }
  }
  if (appStateFromUrl !== null && appStateFromUrl !== void 0 && appStateFromUrl.sort && !appStateFromUrl.sort.length) {
    // If there's an empty array given in the URL, the sort prop should be removed
    // This allows the sort prop to be overwritten with the default sorting
    delete appStateFromUrl.sort;
  }
  if (appStateFromUrl !== null && appStateFromUrl !== void 0 && appStateFromUrl.rowsPerPage && !(typeof appStateFromUrl.rowsPerPage === 'number' && appStateFromUrl.rowsPerPage > 0)) {
    // remove the param if it's invalid
    delete appStateFromUrl.rowsPerPage;
  }
  return appStateFromUrl;
}