"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverStateProvider = exports.DiscoverMainProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _discover_internal_state_container = require("./discover_internal_state_container");
var _discover_app_state_container = require("./discover_app_state_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function createStateHelpers() {
  const context = /*#__PURE__*/_react.default.createContext(null);
  return {
    Provider: context.Provider
  };
}
const {
  Provider: DiscoverStateProvider
} = createStateHelpers();
exports.DiscoverStateProvider = DiscoverStateProvider;
const DiscoverMainProvider = ({
  value,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(DiscoverStateProvider, {
    value: value
  }, /*#__PURE__*/_react.default.createElement(_discover_app_state_container.DiscoverAppStateProvider, {
    value: value.appState
  }, /*#__PURE__*/_react.default.createElement(_discover_internal_state_container.InternalStateProvider, {
    value: value.internalState
  }, children)));
};
exports.DiscoverMainProvider = DiscoverMainProvider;