"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.changeDataView = changeDataView;
var _add_log = require("../../../../utils/add_log");
var _get_switch_data_view_app_state = require("../../utils/get_switch_data_view_app_state");
var _common = require("../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Function executed when switching data view in the UI
 * @param id
 * @param services
 * @param discoverState
 * @param setUrlTracking
 */
async function changeDataView(id, {
  services,
  discoverState,
  setUrlTracking
}) {
  (0, _add_log.addLog)('[ui] changeDataView', {
    id
  });
  const {
    dataViews,
    uiSettings
  } = services;
  const dataView = discoverState.internalState.getState().dataView;
  const state = discoverState.appState.getState();
  let nextDataView = null;
  try {
    nextDataView = await dataViews.get(id, false);
  } catch (e) {
    //
  }
  if (nextDataView && dataView) {
    const nextAppState = (0, _get_switch_data_view_app_state.getDataViewAppState)(dataView, nextDataView, state.columns || [], state.sort || [], uiSettings.get(_common.MODIFY_COLUMNS_ON_SWITCH), uiSettings.get(_common.SORT_DEFAULT_ORDER_SETTING), state.query);
    setUrlTracking(nextDataView);
    discoverState.appState.update(nextAppState);
  }
}