"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrlTracking = useUrlTracking;
var _react = require("react");
var _kibana_services = require("../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Enable/disable kbn url tracking (That's the URL used when selecting Discover in the side menu)
 */
function useUrlTracking(savedSearch, dataView) {
  const setUrlTracking = (0, _react.useCallback)(actualDataView => {
    const trackingEnabled = Boolean(actualDataView.isPersisted() || savedSearch.id);
    (0, _kibana_services.getUrlTracker)().setTrackingEnabled(trackingEnabled);
  }, [savedSearch]);
  (0, _react.useEffect)(() => {
    setUrlTracking(dataView);
  }, [dataView, savedSearch.id, setUrlTracking]);
  return {
    setUrlTracking
  };
}