"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrl = useUrl;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function useUrl({
  history,
  resetSavedSearch
}) {
  /**
   * Url / Routing logic
   */
  (0, _react.useEffect)(() => {
    // this listener is waiting for such a path http://localhost:5601/app/discover#/
    // which could be set through pressing "New" button in top nav or go to "Discover" plugin from the sidebar
    // to reload the page in a right way
    const unlistenHistoryBasePath = history.listen(({
      pathname,
      search,
      hash
    }) => {
      if (!search && !hash && pathname === '/') {
        resetSavedSearch();
      }
    });
    return () => unlistenHistoryBasePath();
  }, [history, resetSavedSearch]);
}