"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchSession = useSearchSession;
var _react = require("react");
var _public = require("@kbn/data-plugin/public");
var _discover_state = require("../services/discover_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function useSearchSession({
  services,
  stateContainer,
  savedSearch
}) {
  const {
    data,
    capabilities
  } = services;
  (0, _react.useEffect)(() => {
    data.search.session.enableStorage((0, _discover_state.createSearchSessionRestorationDataProvider)({
      appStateContainer: stateContainer.appState,
      data,
      getSavedSearch: () => savedSearch
    }), {
      isDisabled: () => capabilities.discover.storeSearchSession ? {
        disabled: false
      } : {
        disabled: true,
        reasonText: _public.noSearchSessionStorageCapabilityMessage
      }
    });
  }, [capabilities.discover.storeSearchSession, data, savedSearch, stateContainer.appState]);
}