"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFiltersValidation = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const addInvalidFiltersWarn = toastNotifications => {
  const warningTitle = _i18n.i18n.translate('discover.invalidFiltersWarnToast.title', {
    defaultMessage: 'Different index references'
  });
  toastNotifications.addWarning({
    title: warningTitle,
    text: _i18n.i18n.translate('discover.invalidFiltersWarnToast.description', {
      defaultMessage: 'Data view id references in some of the applied filters differ from the current data view.'
    }),
    'data-test-subj': 'invalidFiltersWarnToast'
  });
};
const useFiltersValidation = ({
  savedSearch,
  filterManager,
  toastNotifications
}) => {
  (0, _react.useEffect)(() => {
    const subscription = filterManager.getUpdates$().pipe((0, _rxjs.debounceTime)(500)).subscribe(() => {
      const currentFilters = filterManager.getFilters();
      const dataView = savedSearch.searchSource.getField('index');
      const areFiltersInvalid = dataView && !dataView.isPersisted() && !currentFilters.every(current => current.meta.index === dataView.id);
      if (areFiltersInvalid) {
        addInvalidFiltersWarn(toastNotifications);
      }
    });
    return () => subscription.unsubscribe();
  }, [filterManager, savedSearch.searchSource, toastNotifications]);
};
exports.useFiltersValidation = useFiltersValidation;