"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverMainRoute = DiscoverMainRoute;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-views-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _public3 = require("@kbn/kibana-react-plugin/public");
var _sharedUxPageAnalyticsNoData = require("@kbn/shared-ux-page-analytics-no-data");
var _public4 = require("@kbn/saved-search-plugin/public");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _discover_state = require("./services/discover_state");
var _resolve_data_view = require("./utils/resolve_data_view");
var _discover_main_app = require("./discover_main_app");
var _breadcrumbs = require("../../utils/breadcrumbs");
var _loading_indicator = require("../../components/common/loading_indicator");
var _error_alert = require("../../components/common/error_alert");
var _use_discover_services = require("../../hooks/use_discover_services");
var _kibana_services = require("../../kibana_services");
var _restore_from_saved_search = require("../../services/saved_searches/restore_from_saved_search");
var _use_alert_results_toast = require("./hooks/use_alert_results_toast");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverMainAppMemoized = /*#__PURE__*/(0, _react.memo)(_discover_main_app.DiscoverMainApp);
function DiscoverMainRoute(props) {
  const history = (0, _reactRouterDom.useHistory)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    isDev
  } = props;
  const {
    core,
    chrome,
    uiSettings: config,
    data,
    toastNotifications,
    http: {
      basePath
    },
    dataViewEditor
  } = services;
  const [error, setError] = (0, _react.useState)();
  const [loading, setLoading] = (0, _react.useState)(true);
  const [savedSearch, setSavedSearch] = (0, _react.useState)();
  const [dataViewList, setDataViewList] = (0, _react.useState)([]);
  const [hasESData, setHasESData] = (0, _react.useState)(false);
  const [hasUserDataView, setHasUserDataView] = (0, _react.useState)(false);
  const [showNoDataPage, setShowNoDataPage] = (0, _react.useState)(false);
  const hasCustomBranding = (0, _useObservable.default)(core.customBranding.hasCustomBranding$, false);
  const {
    id
  } = (0, _reactRouterDom.useParams)();

  /**
   * Get location state of scoped history only on initial load
   */
  const historyLocationState = (0, _react.useMemo)(() => (0, _kibana_services.getScopedHistory)().location.state, []);
  (0, _use_alert_results_toast.useAlertResultsToast)({
    isAlertResults: historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.isAlertResults,
    toastNotifications
  });
  (0, _public3.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'app',
    id: id || 'new'
  });
  const loadDefaultOrCurrentDataView = (0, _react.useCallback)(async nextSavedSearch => {
    try {
      const hasUserDataViewValue = await data.dataViews.hasData.hasUserDataView().catch(() => false);
      const hasESDataValue = isDev || (await data.dataViews.hasData.hasESData().catch(() => false));
      setHasUserDataView(hasUserDataViewValue);
      setHasESData(hasESDataValue);
      if (!hasUserDataViewValue) {
        setShowNoDataPage(true);
        return;
      }
      let defaultDataView = null;
      try {
        defaultDataView = await data.dataViews.getDefaultDataView({
          displayErrors: false
        });
      } catch (e) {
        //
      }
      if (!defaultDataView) {
        setShowNoDataPage(true);
        return;
      }
      const {
        appState
      } = (0, _discover_state.getDiscoverStateContainer)({
        history,
        savedSearch: nextSavedSearch,
        services
      });
      const {
        index,
        query
      } = appState.getState();
      const ip = await (0, _resolve_data_view.loadDataView)(data.dataViews, config, index, historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.dataViewSpec);
      const ipList = ip.list;
      const isTextBasedQuery = query && (0, _esQuery.isOfAggregateQueryType)(query);
      const dataViewData = (0, _resolve_data_view.resolveDataView)(ip, nextSavedSearch.searchSource, toastNotifications, isTextBasedQuery);
      setDataViewList(ipList);
      return dataViewData;
    } catch (e) {
      setError(e);
    }
  }, [config, data.dataViews, history, isDev, historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.dataViewSpec, toastNotifications, services]);
  const loadSavedSearch = (0, _react.useCallback)(async nextDataView => {
    try {
      setLoading(true);
      const currentSavedSearch = await (0, _public4.getSavedSearch)(id, {
        search: services.data.search,
        savedObjectsClient: core.savedObjects.client,
        spaces: services.spaces,
        savedObjectsTagging: services.savedObjectsTagging
      });
      const currentDataView = nextDataView ? nextDataView : await loadDefaultOrCurrentDataView(currentSavedSearch);
      if (!currentDataView) {
        return;
      }
      if (!currentSavedSearch.searchSource.getField('index')) {
        currentSavedSearch.searchSource.setField('index', currentDataView);
      }
      (0, _restore_from_saved_search.restoreStateFromSavedSearch)({
        savedSearch: currentSavedSearch,
        timefilter: services.timefilter
      });
      setSavedSearch(currentSavedSearch);
      if (currentSavedSearch.id) {
        var _currentSavedSearch$t;
        chrome.recentlyAccessed.add((0, _public4.getSavedSearchFullPathUrl)(currentSavedSearch.id), (_currentSavedSearch$t = currentSavedSearch.title) !== null && _currentSavedSearch$t !== void 0 ? _currentSavedSearch$t : '', currentSavedSearch.id);
      }
      setLoading(false);
    } catch (e) {
      if (e instanceof _public.DataViewSavedObjectConflictError) {
        setError(e);
      } else {
        (0, _public2.redirectWhenMissing)({
          history,
          navigateToApp: core.application.navigateToApp,
          basePath,
          mapping: {
            search: '/',
            'index-pattern': {
              app: 'management',
              path: `kibana/objects/savedSearches/${id}`
            }
          },
          toastNotifications,
          onBeforeRedirect() {
            (0, _kibana_services.getUrlTracker)().setTrackedUrl('/');
          },
          theme: core.theme
        })(e);
      }
    }
  }, [id, services.data, services.spaces, services.timefilter, services.savedObjectsTagging, core.savedObjects.client, core.application.navigateToApp, core.theme, loadDefaultOrCurrentDataView, chrome.recentlyAccessed, history, basePath, toastNotifications]);
  const onDataViewCreated = (0, _react.useCallback)(async nextDataView => {
    if (nextDataView) {
      setLoading(true);
      setShowNoDataPage(false);
      setError(undefined);
      await loadSavedSearch(nextDataView);
    }
  }, [loadSavedSearch]);
  (0, _react.useEffect)(() => {
    loadSavedSearch();
  }, [loadSavedSearch]);
  (0, _react.useEffect)(() => {
    chrome.setBreadcrumbs(savedSearch && savedSearch.title ? (0, _breadcrumbs.getSavedSearchBreadcrumbs)(savedSearch.title) : (0, _breadcrumbs.getRootBreadcrumbs)());
  }, [chrome, savedSearch]);
  if (showNoDataPage) {
    const analyticsServices = {
      coreStart: core,
      dataViews: {
        ...data.dataViews,
        hasData: {
          ...data.dataViews.hasData,
          // We've already called this, so we can optimize the analytics services to
          // use the already-retrieved data to avoid a double-call.
          hasESData: () => Promise.resolve(isDev ? true : hasESData),
          hasUserDataView: () => Promise.resolve(hasUserDataView)
        }
      },
      dataViewEditor
    };
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageAnalyticsNoData.AnalyticsNoDataPageKibanaProvider, analyticsServices, /*#__PURE__*/_react.default.createElement(_sharedUxPageAnalyticsNoData.AnalyticsNoDataPage, {
      onDataViewCreated: onDataViewCreated,
      allowAdHocDataView: true
    }));
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_error_alert.DiscoverError, {
      error: error
    });
  }
  if (loading || !savedSearch) {
    return /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
      type: hasCustomBranding ? 'spinner' : 'elastic'
    });
  }
  return /*#__PURE__*/_react.default.createElement(DiscoverMainAppMemoized, {
    dataViewList: dataViewList,
    savedSearch: savedSearch
  });
}