"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverMainApp = DiscoverMainApp;
var _react = _interopRequireWildcard(require("react"));
var _domDragDrop = require("@kbn/dom-drag-drop");
var _reactRouterDom = require("react-router-dom");
var _layout = require("./components/layout");
var _breadcrumbs = require("../../utils/breadcrumbs");
var _help_menu_util = require("../../components/help_menu/help_menu_util");
var _use_discover_state = require("./hooks/use_discover_state");
var _use_url = require("./hooks/use_url");
var _use_discover_services = require("../../hooks/use_discover_services");
var _saved_search_alias_match_redirect = require("../../hooks/saved_search_alias_match_redirect");
var _discover_state_provider = require("./services/discover_state_provider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverLayoutMemoized = /*#__PURE__*/_react.default.memo(_layout.DiscoverLayout);
function DiscoverMainApp(props) {
  const {
    savedSearch,
    dataViewList
  } = props;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    chrome,
    docLinks,
    data,
    spaces,
    history
  } = services;
  const usedHistory = (0, _reactRouterDom.useHistory)();
  const navigateTo = (0, _react.useCallback)(path => {
    usedHistory.push(path);
  }, [usedHistory]);

  /**
   * State related logic
   */
  const {
    inspectorAdapters,
    onChangeDataView,
    onUpdateQuery,
    persistDataView,
    updateAdHocDataViewId,
    resetSavedSearch,
    searchSource,
    stateContainer,
    updateDataViewList
  } = (0, _use_discover_state.useDiscoverState)({
    services,
    history: usedHistory,
    savedSearch
  });

  /**
   * Url / Routing logic
   */
  (0, _use_url.useUrl)({
    history: usedHistory,
    resetSavedSearch
  });

  /**
   * SavedSearch depended initializing
   */
  (0, _react.useEffect)(() => {
    const pageTitleSuffix = savedSearch.id && savedSearch.title ? `: ${savedSearch.title}` : '';
    chrome.docTitle.change(`Discover${pageTitleSuffix}`);
    (0, _breadcrumbs.setBreadcrumbsTitle)(savedSearch, chrome);
    return () => {
      data.search.session.clear();
    };
  }, [savedSearch, chrome, data]);

  /**
   * Initializing syncing with state and help menu
   */
  (0, _react.useEffect)(() => {
    (0, _help_menu_util.addHelpMenuToAppChrome)(chrome, docLinks);
  }, [stateContainer, chrome, docLinks]);

  /**
   * Set initial data view list
   * Can be removed once the state container work was completed
   */
  (0, _react.useEffect)(() => {
    stateContainer.internalState.transitions.setSavedDataViews(dataViewList);
  }, [stateContainer, dataViewList]);
  const resetCurrentSavedSearch = (0, _react.useCallback)(() => {
    resetSavedSearch(savedSearch.id);
  }, [resetSavedSearch, savedSearch]);
  (0, _saved_search_alias_match_redirect.useSavedSearchAliasMatchRedirect)({
    savedSearch,
    spaces,
    history
  });
  return /*#__PURE__*/_react.default.createElement(_discover_state_provider.DiscoverMainProvider, {
    value: stateContainer
  }, /*#__PURE__*/_react.default.createElement(_domDragDrop.RootDragDropProvider, null, /*#__PURE__*/_react.default.createElement(DiscoverLayoutMemoized, {
    inspectorAdapters: inspectorAdapters,
    onChangeDataView: onChangeDataView,
    onUpdateQuery: onUpdateQuery,
    resetSavedSearch: resetCurrentSavedSearch,
    navigateTo: navigateTo,
    savedSearch: savedSearch,
    searchSource: searchSource,
    stateContainer: stateContainer,
    persistDataView: persistDataView,
    updateAdHocDataViewId: updateAdHocDataViewId,
    updateDataViewList: updateDataViewList
  })));
}