"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsPopover = OptionsPopover;
exports.openOptionsPopover = openOptionsPopover;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
require("./open_options_popover.scss");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _common = require("../../../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const container = document.createElement('div');
let isOpen = false;
function OptionsPopover(props) {
  const {
    core: {
      uiSettings
    },
    addBasePath
  } = (0, _use_discover_services.useDiscoverServices)();
  const isLegacy = uiSettings.get(_common.DOC_TABLE_LEGACY);
  const mode = isLegacy ? _i18n.i18n.translate('discover.openOptionsPopover.classicDiscoverText', {
    defaultMessage: 'Classic'
  }) : _i18n.i18n.translate('discover.openOptionsPopover.documentExplorerText', {
    defaultMessage: 'Document Explorer'
  });
  const {
    anchorElement,
    onClose: originalOnClose
  } = props;
  const closePopover = (0, _react.useCallback)(() => {
    originalOnClose();
    anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.focus();
  }, [anchorElement, originalOnClose]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    ownFocus: true,
    button: props.anchorElement,
    closePopover: closePopover,
    isOpen: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "dscOptionsPopover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.topNav.optionsPopover.currentViewMode",
    defaultMessage: "{viewModeLabel}: {currentViewMode}",
    values: {
      viewModeLabel: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.topNav.optionsPopover.discoverViewModeLabel",
        defaultMessage: "Discover view mode"
      })),
      currentViewMode: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        "data-test-subj": "docTableMode"
      }, mode)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, isLegacy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.topNav.openOptionsPopover.documentExplorerDisabledHint",
    defaultMessage: "Did you know Discover has a new Document Explorer with better data sorting, resizable columns, and a full screen view? You can change the view mode in Advanced Settings."
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.topNav.openOptionsPopover.documentExplorerEnabledHint",
    defaultMessage: "You can switch back to the classic Discover view in Advanced Settings."
  })), isLegacy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "tableDensityNormal",
    fullWidth: true,
    href: addBasePath(`/app/management/kibana/settings?query=${_common.DOC_TABLE_LEGACY}`)
  }, _i18n.i18n.translate('discover.openOptionsPopover.tryDocumentExplorer', {
    defaultMessage: 'Try Document Explorer'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "gear",
    size: "s",
    href: addBasePath(`/app/management/kibana/settings?query=category:(discover)`)
  }, _i18n.i18n.translate('discover.openOptionsPopover.gotToSettings', {
    defaultMessage: 'View Discover settings'
  })))));
}
function onClose() {
  _reactDom.default.unmountComponentAtNode(container);
  document.body.removeChild(container);
  isOpen = false;
}
function openOptionsPopover({
  I18nContext,
  anchorElement,
  theme$,
  services
}) {
  if (isOpen) {
    onClose();
    return;
  }
  isOpen = true;
  document.body.appendChild(container);
  const element = /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(OptionsPopover, {
    onClose: onClose,
    anchorElement: anchorElement
  }))));
  _reactDom.default.render(element, container);
}