"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopNavLinks = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _show_open_search_panel = require("./show_open_search_panel");
var _get_sharing_data = require("../../../../utils/get_sharing_data");
var _on_save_search = require("./on_save_search");
var _open_options_popover = require("./open_options_popover");
var _open_alerts_popover = require("./open_alerts_popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Helper function to build the top nav links
 */
const getTopNavLinks = ({
  dataView,
  navigateTo,
  savedSearch,
  services,
  state,
  onOpenInspector,
  searchSource,
  onOpenSavedSearch,
  isPlainRecord,
  persistDataView,
  adHocDataViews,
  updateDataViewList,
  updateAdHocDataViewId
}) => {
  var _services$capabilitie, _services$capabilitie2;
  const options = {
    id: 'options',
    label: _i18n.i18n.translate('discover.localMenu.localMenu.optionsTitle', {
      defaultMessage: 'Options'
    }),
    description: _i18n.i18n.translate('discover.localMenu.optionsDescription', {
      defaultMessage: 'Options'
    }),
    run: anchorElement => (0, _open_options_popover.openOptionsPopover)({
      I18nContext: services.core.i18n.Context,
      anchorElement,
      theme$: services.core.theme.theme$,
      services
    }),
    testId: 'discoverOptionsButton'
  };
  const alerts = {
    id: 'alerts',
    label: _i18n.i18n.translate('discover.localMenu.localMenu.alertsTitle', {
      defaultMessage: 'Alerts'
    }),
    description: _i18n.i18n.translate('discover.localMenu.alertsDescription', {
      defaultMessage: 'Alerts'
    }),
    run: async anchorElement => {
      (0, _open_alerts_popover.openAlertsPopover)({
        I18nContext: services.core.i18n.Context,
        theme$: services.core.theme.theme$,
        anchorElement,
        searchSource: savedSearch.searchSource,
        services,
        adHocDataViews,
        updateDataViewList,
        savedQueryId: state.appState.getState().savedQuery
      });
    },
    testId: 'discoverAlertsButton'
  };
  const newSearch = {
    id: 'new',
    label: _i18n.i18n.translate('discover.localMenu.localMenu.newSearchTitle', {
      defaultMessage: 'New'
    }),
    description: _i18n.i18n.translate('discover.localMenu.newSearchDescription', {
      defaultMessage: 'New Search'
    }),
    run: () => navigateTo('/'),
    testId: 'discoverNewButton'
  };
  const saveSearch = {
    id: 'save',
    label: _i18n.i18n.translate('discover.localMenu.saveTitle', {
      defaultMessage: 'Save'
    }),
    description: _i18n.i18n.translate('discover.localMenu.saveSearchDescription', {
      defaultMessage: 'Save Search'
    }),
    testId: 'discoverSaveButton',
    iconType: 'save',
    emphasize: true,
    run: anchorElement => {
      (0, _on_save_search.onSaveSearch)({
        savedSearch,
        services,
        dataView,
        navigateTo,
        state,
        updateAdHocDataViewId,
        onClose: () => {
          anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.focus();
        }
      });
    }
  };
  const openSearch = {
    id: 'open',
    label: _i18n.i18n.translate('discover.localMenu.openTitle', {
      defaultMessage: 'Open'
    }),
    description: _i18n.i18n.translate('discover.localMenu.openSavedSearchDescription', {
      defaultMessage: 'Open Saved Search'
    }),
    testId: 'discoverOpenButton',
    run: () => (0, _show_open_search_panel.showOpenSearchPanel)({
      onOpenSavedSearch,
      I18nContext: services.core.i18n.Context,
      theme$: services.core.theme.theme$,
      services
    })
  };
  const shareSearch = {
    id: 'share',
    label: _i18n.i18n.translate('discover.localMenu.shareTitle', {
      defaultMessage: 'Share'
    }),
    description: _i18n.i18n.translate('discover.localMenu.shareSearchDescription', {
      defaultMessage: 'Share Search'
    }),
    testId: 'shareTopNavButton',
    run: async anchorElement => {
      const updatedDataView = await persistDataView(dataView);
      if (!services.share || !updatedDataView) {
        return;
      }
      const sharingData = await (0, _get_sharing_data.getSharingData)(searchSource, state.appState.getState(), services);
      services.share.toggleShareContextMenu({
        anchorElement,
        allowEmbed: false,
        allowShortUrl: !!services.capabilities.discover.createShortUrl,
        shareableUrl: (0, _public.unhashUrl)(window.location.href),
        objectId: savedSearch.id,
        objectType: 'search',
        sharingData: {
          ...sharingData,
          // CSV reports can be generated without a saved search so we provide a fallback title
          title: savedSearch.title || _i18n.i18n.translate('discover.localMenu.fallbackReportTitle', {
            defaultMessage: 'Untitled discover search'
          })
        },
        isDirty: !savedSearch.id || state.appState.hasChanged(),
        showPublicUrlSwitch: _get_sharing_data.showPublicUrlSwitch,
        onClose: () => {
          anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.focus();
        }
      });
    }
  };
  const inspectSearch = {
    id: 'inspect',
    label: _i18n.i18n.translate('discover.localMenu.inspectTitle', {
      defaultMessage: 'Inspect'
    }),
    description: _i18n.i18n.translate('discover.localMenu.openInspectorForSearchDescription', {
      defaultMessage: 'Open Inspector for search'
    }),
    testId: 'openInspectorButton',
    run: () => {
      onOpenInspector();
    }
  };
  return [...(services.capabilities.advancedSettings.save ? [options] : []), newSearch, openSearch, ...(!isPlainRecord ? [shareSearch] : []), ...(services.triggersActionsUi && (_services$capabilitie = services.capabilities.management) !== null && _services$capabilitie !== void 0 && (_services$capabilitie2 = _services$capabilitie.insightsAndAlerting) !== null && _services$capabilitie2 !== void 0 && _services$capabilitie2.triggersActions && !isPlainRecord ? [alerts] : []), inspectSearch, ...(services.capabilities.discover.save ? [saveSearch] : [])];
};
exports.getTopNavLinks = getTopNavLinks;